/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LocatorFactoryImpl;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.NavigationImpl;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertionsImpl;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.log.FuncTestLoggerImpl;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import java.util.Locale;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;

public class TimeTrackingImpl
implements TimeTracking {
    private final WebTester tester;
    private final JIRAEnvironmentData environmentData;
    private final FuncTestLogger logger;
    private final TextAssertions textAssertions;
    private final LocatorFactory locators;
    private Navigation navigation;

    @Inject
    public TimeTrackingImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        this.tester = tester;
        this.environmentData = environmentData;
        this.logger = new FuncTestLoggerImpl(2);
        this.textAssertions = new TextAssertionsImpl(tester);
        this.locators = new LocatorFactoryImpl(tester);
    }

    @Override
    public void enable(TimeTracking.Mode mode) {
        this.logger.log((Object)"Activating time tracking");
        this.tester.gotoPage("/secure/admin/jira/TimeTrackingAdmin!default.jspa");
        if (this.tester.getDialog().hasSubmitButton("Activate")) {
            if (mode.equals((Object)TimeTracking.Mode.LEGACY)) {
                this.tester.checkCheckbox("legacyMode", "true");
            } else {
                this.tester.uncheckCheckbox("legacyMode");
            }
            this.tester.submit("Activate");
        } else {
            this.logger.log((Object)"Time tracking already activated.");
        }
    }

    @Override
    public void switchMode(TimeTracking.Mode mode) {
        this.disable();
        this.enable(mode);
    }

    @Override
    public void enable(TimeTracking.Format format) {
        this.logger.log((Object)"Activating time tracking");
        this.tester.gotoPage("/secure/admin/jira/TimeTrackingAdmin!default.jspa");
        if (this.tester.getDialog().hasSubmitButton("Activate")) {
            this.tester.checkCheckbox("timeTrackingFormat", TimeTrackingImpl.lowerName(format));
            this.tester.submit("Activate");
        } else {
            this.logger.log((Object)"Time tracking already activated.");
        }
    }

    @Override
    public void enable(String hoursPerDay, String daysPerWeek, String format, String defaultUnit, TimeTracking.Mode mode) {
        this.logger.log((Object)"Activating time tracking");
        this.tester.gotoPage("/secure/admin/jira/TimeTrackingAdmin!default.jspa");
        if (this.tester.getDialog().hasSubmitButton("Activate")) {
            this.tester.setFormElement("hoursPerDay", hoursPerDay);
            this.tester.setFormElement("daysPerWeek", daysPerWeek);
            this.tester.checkCheckbox("timeTrackingFormat", format);
            this.tester.selectOption("defaultUnit", defaultUnit);
            if (mode.equals((Object)TimeTracking.Mode.LEGACY)) {
                this.tester.checkCheckbox("legacyMode", "true");
            } else {
                this.tester.uncheckCheckbox("legacyMode");
            }
            this.tester.submit("Activate");
            this.tester.assertTextPresent(String.format("The current default unit for time tracking is <b>%s</b>.", defaultUnit));
        } else {
            this.logger.log((Object)"Time tracking already activated.");
        }
    }

    @Override
    public void enable(String hoursPerDay, String daysPerWeek, TimeTracking.Format format, TimeTracking.Unit defaultUnit, TimeTracking.Mode mode) {
        this.enable(hoursPerDay, daysPerWeek, TimeTrackingImpl.lowerName(format), TimeTrackingImpl.lowerName(defaultUnit), TimeTracking.Mode.MODERN);
    }

    private static String lowerName(Enum<?> e) {
        return e.name().toLowerCase(Locale.ENGLISH);
    }

    private void enable(boolean copyCommentEnabled) {
        this.logger.log((Object)"Activating time tracking");
        this.tester.gotoPage("/secure/admin/jira/TimeTrackingAdmin!default.jspa");
        if (this.tester.getDialog().hasSubmitButton("Activate")) {
            if (copyCommentEnabled) {
                this.tester.checkCheckbox("copyComment", "true");
            } else {
                this.tester.uncheckCheckbox("copyComment");
            }
            this.tester.submit("Activate");
        } else {
            this.logger.log((Object)"Time tracking already activated.");
        }
    }

    @Override
    public void disable() {
        this.logger.log((Object)"Deactivating time tracking.");
        this.tester.gotoPage("/secure/admin/jira/TimeTrackingAdmin!default.jspa");
        this.submitAtPage("/secure/admin/jira/TimeTrackingAdmin!default.jspa", "Deactivate", "time tracking already deactivated");
    }

    protected void submitAtPage(String url, String button, String logOnFail) {
        this.tester.gotoPage(url);
        if (this.tester.getDialog().hasSubmitButton(button)) {
            this.tester.submit(button);
        } else if (logOnFail != null) {
            this.logger.log((Object)logOnFail);
        }
    }

    @Override
    public boolean isIn(TimeTracking.Mode mode) {
        this.tester.gotoPage("/secure/admin/jira/TimeTrackingAdmin!default.jspa");
        if (this.isEnabled()) {
            return TimeTracking.Mode.MODERN == mode ^ this.locators.id("legacy-on").exists();
        }
        return false;
    }

    @Override
    public void disableCopyingOfComments() {
        if (this.isEnabled()) {
            this.disable();
        }
        this.enable(false);
        this.textAssertions.assertTextSequence(new WebPageLocator(this.tester), "Copying of comments to work description is currently", "disabled", "For the users you wish");
    }

    @Override
    public void switchFormat(TimeTracking.Format format) {
        this.disable();
        this.enable(format);
    }

    private boolean isEnabled() {
        if (this.navigation == null) {
            this.navigation = new NavigationImpl(this.tester, this.environmentData);
        }
        if (!this.navigation.getCurrentPage().equals("/secure/admin/jira/TimeTrackingAdmin!default.jspa")) {
            this.tester.gotoPage("/secure/admin/jira/TimeTrackingAdmin!default.jspa");
        }
        return this.tester.getDialog().hasSubmitButton("Deactivate");
    }
}

