/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.FunctTestConstants;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.services.EditService;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.webtests.table.HtmlTable;
import com.google.common.collect.ImmutableSet;
import com.meterware.httpunit.WebTable;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.w3c.dom.Node;

public class ViewServices
implements FunctTestConstants {
    private static final String SERVICES_TABLE_ID = "tbl_services";
    private final WebTester tester;
    private final Navigation navigation;

    @Inject
    public ViewServices(WebTester tester, Navigation navigation) {
        this.tester = tester;
        this.navigation = navigation;
    }

    public ViewServices goTo() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.SERVICES);
        return this;
    }

    public ViewServices add(Service service, String delayInMinutes) throws UnableToAddServiceException {
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("name", service.getName());
        this.tester.setFormElement("clazz", service.getServiceClass());
        this.tester.setFormElement("service.schedule.cronString", String.format("0 0/%1s * * * ?", delayInMinutes));
        this.tester.submit();
        if (!this.tester.getDialog().hasSubmitButton("Update")) {
            throw new UnableToAddServiceException(String.format("Unable to add a service with name: %s and class: %s", service.getName(), service.getServiceClass()));
        }
        this.tester.submit("Update");
        return this;
    }

    public EditService edit(Service service) {
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//*[@id='tbl_services']//tr[contains(@id,'service')]");
        for (Node node : xPathLocator.getNodes()) {
            XPathLocator serviceNameLocator = new XPathLocator(node, ".//*[contains(@id,'service-name')]");
            if (!serviceNameLocator.getText().equals(service.getName())) continue;
            String serviceId = StringUtils.difference((String)"service-", (String)node.getAttributes().getNamedItem("id").getNodeValue());
            this.tester.clickLink("edit_" + serviceId);
            return new EditService(this, this.tester);
        }
        throw new AssertionError((Object)("No service could be found with the name: " + service.getName()));
    }

    public Set<Service> list() {
        HashSet<Service> services = new HashSet<Service>();
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//*[@id='tbl_services']//tr[contains(@id,'service')]");
        for (Node node : xPathLocator.getNodes()) {
            XPathLocator serviceNameLocator = new XPathLocator(node, ".//*[contains(@id,'service-name')]");
            XPathLocator serviceClassLocator = new XPathLocator(node, ".//*[contains(@id,'service-class')]");
            services.add(new Service(serviceNameLocator.getText(), serviceClassLocator.getText()));
        }
        return ImmutableSet.copyOf(services);
    }

    public long getIdForServiceName(String name) {
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//*[@id='tbl_services']//tr[contains(@id,'service')]");
        for (Node node : xPathLocator.getNodes()) {
            XPathLocator serviceNameLocator = new XPathLocator(node, ".//*[contains(@id,'service-name')]");
            if (!serviceNameLocator.getText().equals(name)) continue;
            String serviceId = StringUtils.difference((String)"service-", (String)node.getAttributes().getNamedItem("id").getNodeValue());
            return Long.parseLong(serviceId);
        }
        throw new AssertionError((Object)("No service could be found with the name: " + name));
    }

    public void clickEdit(String serviceName) {
        this.clickLink(serviceName, "Edit");
    }

    public void clickDelete(String serviceName) {
        this.clickLink(serviceName, "Delete");
    }

    private void clickLink(String serviceName, String linkName) {
        WebTable table = this.tester.getDialog().getWebTableBySummaryOrId(SERVICES_TABLE_ID);
        if (table == null) {
            this.goTo();
            table = this.tester.getDialog().getWebTableBySummaryOrId(SERVICES_TABLE_ID);
        }
        HtmlTable htmlTable = new HtmlTable(table);
        HtmlTable.Row row = htmlTable.findRowWhereCellStartsWith(1, serviceName);
        this.navigation.clickLinkInTableCell(table, row.getRowIndex(), 4, linkName);
    }

    public class UnableToAddServiceException
    extends Exception {
        public UnableToAddServiceException() {
        }

        public UnableToAddServiceException(String message) {
            super(message);
        }

        public UnableToAddServiceException(String message, Throwable cause) {
            super(message, cause);
        }

        public UnableToAddServiceException(Throwable cause) {
            super(cause);
        }
    }

    public static class Service {
        private final String name;
        private final String serviceClass;

        public Service(String name, String serviceClass) {
            this.name = name;
            this.serviceClass = serviceClass;
        }

        public String getName() {
            return this.name;
        }

        public String getServiceClass() {
            return this.serviceClass;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Service)) {
                return false;
            }
            Service rhs = (Service)obj;
            return new EqualsBuilder().append((Object)this.name, (Object)rhs.name).append((Object)this.serviceClass, (Object)rhs.getServiceClass()).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 31).append((Object)this.name).append((Object)this.serviceClass).toHashCode();
        }
    }
}

