/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.jira.functest.framework.assertions.HTMLAssertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertionsImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.annotation.Nonnull;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.text.StringEscapeUtils;

public class HTMLAssertionsImpl
implements HTMLAssertions {
    @Override
    public void assertContains(String original, String expected) {
        new TextAssertionsImpl(null).assertTextPresent(HTMLAssertionsImpl.unescape(original), expected);
    }

    @Override
    public void assertResponseContains(WebTester tester, String expected) {
        this.assertContains(HTMLAssertionsImpl.getResponseText(tester), expected);
    }

    static String unescape(@Nonnull String escapedText) {
        return StringEscapeUtils.unescapeHtml4((String)escapedText);
    }

    static String getResponseText(@Nonnull WebTester tester) {
        try {
            return tester.getDialog().getResponse().getText();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static class WriterStream
    extends OutputStream {
        private final Writer writer;

        WriterStream(@Nonnull Writer writer) {
            this.writer = writer;
        }

        @Override
        public void write(int b) throws IOException {
            this.writer.write(b);
        }

        @Override
        public void flush() throws IOException {
            this.writer.flush();
        }
    }
}

