/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.jira.functest.framework.assertions.IssueNavigatorAssertions;
import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.functest.framework.util.SearchRendererValue;
import com.atlassian.jira.functest.framework.util.SearchRendererValueResults;
import com.atlassian.jira.functest.framework.util.SearchResults;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import javax.inject.Inject;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class JqlAssertions {
    private final Backdoor backdoor;

    @Inject
    public JqlAssertions(Backdoor backdoor) {
        this.backdoor = backdoor;
    }

    public void assertFitsFilterForm(String jqlQuery, IssueNavigatorAssertions.FilterFormParam ... formParams) {
        ParsedResponse<String> searchersResponse = this.backdoor.searchersClient().getSearchersResponse(jqlQuery);
        Assertions.assertThat((int)searchersResponse.statusCode).isEqualTo(200);
    }

    public void assertTooComplex(String jqlQuery) {
        ParsedResponse<String> searchersResponse = this.backdoor.searchersClient().getSearchersResponse(jqlQuery);
        Assertions.assertThat((int)searchersResponse.statusCode).isEqualTo(400);
        Assertions.assertThat((String)((String)searchersResponse.entity.errorMessages.get(0))).isEqualTo("jqlTooComplex");
    }

    public void assertInvalidContext(String jqlQuery) {
        SearchResults searchers = this.backdoor.searchersClient().getSearchers(jqlQuery);
        SearchRendererValueResults values = searchers.values;
        boolean invalid = false;
        for (String s : values.keySet()) {
            if (((SearchRendererValue)values.get((Object)s)).validSearcher) continue;
            invalid = true;
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)invalid).overridingErrorMessage("Expected invalid searcher", new Object[0])).isTrue();
    }

    public void assertInvalidValue(String jqlQuery) {
        SearchResults searchers = this.backdoor.searchersClient().getSearchers(jqlQuery);
        SearchRendererValueResults values = searchers.values;
        boolean invalid = false;
        for (String s : values.keySet()) {
            Document editHtml = Jsoup.parse((String)((SearchRendererValue)values.get((Object)s)).editHtml);
            if (editHtml.getElementsByClass("invalid_sel").size() <= 0) continue;
            invalid = true;
            break;
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)invalid).overridingErrorMessage("Expected invalid value", new Object[0])).isTrue();
    }
}

