/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.jira.functest.framework.assertions.LabelAssertions;
import com.atlassian.jira.functest.framework.labels.Labels;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;

public class LabelAssertionsImpl
implements LabelAssertions {
    private static final String FIELDID_LABELS = "labels";
    private final WebTester tester;

    @Inject
    public LabelAssertionsImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        this.tester = tester;
    }

    private void assertLabelsExist(Labels labels, String issueId, String fieldId) {
        ((ObjectAssert)Assertions.assertThat((Object)labels).overridingErrorMessage("Labels should exist but can't find labels for issue - " + issueId + ", field - " + fieldId, new Object[0])).isNotNull();
    }

    @Override
    public void assertLabelsExist(String issueId, String fieldId) {
        Labels labels = Labels.parseLabels(this.tester, issueId, fieldId);
        this.assertLabelsExist(labels, issueId, fieldId);
    }

    @Override
    public void assertLabelsDontExist(String issueId, String fieldId) {
        Labels labels = Labels.parseLabels(this.tester, issueId, fieldId);
        ((ObjectAssert)Assertions.assertThat((Object)labels).overridingErrorMessage("Labels should not exist but found labels for issue - " + issueId + ", field - " + fieldId, new Object[0])).isNull();
    }

    public void assertLabelsEmpty(Labels labels) {
        ((AbstractCollectionAssert)Assertions.assertThat(labels.getLabelValues()).overridingErrorMessage("Labels should be empty but contains: " + labels, new Object[0])).isEmpty();
    }

    @Override
    public void assertLabels(String issueId, String fieldId, Labels expectedLabels) {
        Labels labels = Labels.parseLabels(this.tester, issueId, fieldId);
        this.assertLabelsExist(labels, issueId, fieldId);
        Assertions.assertThat((Object)labels).isEqualTo((Object)expectedLabels);
    }

    @Override
    public void assertSystemLabels(String issueId, Labels expectedLabels) {
        this.assertLabels(issueId, FIELDID_LABELS, expectedLabels);
    }

    @Override
    public void assertLabelsContain(String issueId, String fieldId, Labels expectedLabels) {
        Labels labels = Labels.parseLabels(this.tester, issueId, fieldId);
        this.assertLabelsExist(labels, issueId, fieldId);
        Assertions.assertThat((boolean)labels.isEditable()).isEqualTo(expectedLabels.isEditable());
        Assertions.assertThat((boolean)labels.isLinked()).isEqualTo(expectedLabels.isLinked());
        Assertions.assertThat((boolean)labels.isLozenges()).isEqualTo(expectedLabels.isLozenges());
        Assertions.assertThat(labels.getLabelValues()).containsAll(expectedLabels.getLabelValues());
    }
}

