/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;

public class RequestAssertions {
    private final WebTester tester;

    @Inject
    public RequestAssertions(WebTester tester, JIRAEnvironmentData environmentData) {
        this.tester = tester;
    }

    public void assertResponseCanBeCached() {
        String cacheControl = this.tester.getDialog().getResponse().getHeaderField("Cache-control");
        String[] values = new String[]{"no-cache", "no-store"};
        if (cacheControl != null && StringUtils.isNotEmpty((CharSequence)cacheControl)) {
            for (String value : values) {
                ((AbstractStringAssert)Assertions.assertThat((String)cacheControl).overridingErrorMessage("Response cannot be cached: found '" + value + "' in Cache-control header", new Object[0])).doesNotContain(new CharSequence[]{value});
            }
        }
    }
}

