/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.jira.functest.framework.util.text.TextKit;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.log.FuncTestLoggerImpl;
import com.atlassian.jira.webtests.table.ImageCell;
import com.atlassian.jira.webtests.table.SimpleCell;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.WebImage;
import com.meterware.httpunit.WebTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.assertj.core.api.ObjectArrayAssert;

public class TableAssertions {
    private static ContainsChecker containsChecker = new ContainsChecker();
    private static EqualsChecker equalsChecker = new EqualsChecker();
    private static StrictWhitespaceContainsChecker strictWhitespaceContainsChecker = new StrictWhitespaceContainsChecker();
    private final WebTester tester;
    private final FuncTestLogger logger;

    @Inject
    public TableAssertions(WebTester tester, JIRAEnvironmentData environmentData) {
        this.tester = tester;
        this.logger = new FuncTestLoggerImpl(2);
    }

    public WebTable getWebTable(String tableSummaryOrId) {
        return this.tester.getDialog().getWebTableBySummaryOrId(tableSummaryOrId);
    }

    public void assertTableContainsRowOnce(WebTable webTable, Object[] expectedRow) {
        this.assertTableContainsRowOnce(webTable, expectedRow, false);
    }

    public void assertTableContainsRowOnce(WebTable webTable, Object[] expectedRow, boolean exactCellSearching) {
        int numRows = this.countNumRows(webTable, expectedRow, exactCellSearching);
        if (numRows == 0) {
            Fail.fail((String)("Did not find expected row in table. Expected row = " + this.rowToString(expectedRow)));
        }
        if (numRows > 1) {
            Fail.fail((String)("Expected to find one copy of the row in table, but found " + numRows + ". Expected row = " + this.rowToString(expectedRow)));
        }
    }

    public void assertTableContainsRow(WebTable webTable, String[] expectedRow) {
        int numRows = this.countNumRows(webTable, expectedRow);
        ((AbstractIntegerAssert)Assertions.assertThat((int)numRows).overridingErrorMessage("Did not find expected row in table. Expected row = " + this.rowToString(expectedRow), new Object[0])).isNotZero();
    }

    public void assertTableContainsRowCount(WebTable webTable, String[] expectedRow, int expectedCount) {
        int numRows = this.countNumRows(webTable, expectedRow);
        ((AbstractIntegerAssert)Assertions.assertThat((int)numRows).overridingErrorMessage("Expected " + expectedCount + " row entries in table but found " + numRows + ". Expected row = " + this.rowToString(expectedRow), new Object[0])).isEqualTo(expectedCount);
    }

    public void assertTableRowEquals(WebTable table, int row, Object[] expectedRow) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.tableRowEquals(table, row, Arrays.asList(expectedRow), strictWhitespaceContainsChecker)).overridingErrorMessage("Expected row '" + this.rowToString(expectedRow) + "' does not match '" + this.getTableRowAsList(table, row) + "' (row '" + row + "' of table '" + table.getID() + "')", new Object[0])).isTrue();
    }

    public void assertTableRowEqualsCollapsed(WebTable table, int row, Object[] expectedRow) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.tableRowEquals(table, row, Arrays.asList(expectedRow), equalsChecker)).overridingErrorMessage("Expected row '" + this.rowToString(expectedRow) + "' does not match '" + this.getTableRowAsList(table, row) + "' (row '" + row + "' of table '" + table.getID() + "')", new Object[0])).isTrue();
    }

    public void assertTableCellHasText(WebTable webTable, int row, int column, String text) {
        Assertions.assertThat((Object)webTable).isNotNull();
        boolean hasText = containsChecker.check(webTable, row, column, text);
        String actualText = webTable.getCellAsText(row, column);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)hasText).overridingErrorMessage("expected to find [" + text + "], somewhere in [" + actualText + "] but obviously couldn't.", new Object[0])).isTrue();
    }

    public void assertTableCellDoesNotHaveText(WebTable webTable, int row, int column, String text) {
        Assertions.assertThat((Object)webTable).isNotNull();
        boolean hasText = containsChecker.check(webTable, row, column, text);
        String actualText = webTable.getCellAsText(row, column);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)hasText).overridingErrorMessage("didn't expect to find [" + text + "], somewhere in [" + actualText + "] but here you go.", new Object[0])).isFalse();
    }

    public void assertTableCellHasNoText(WebTable webTable, int row, int column, String text) {
        Assertions.assertThat((Object)webTable).isNotNull();
        boolean hasText = containsChecker.check(webTable, row, column, text);
        String actualText = webTable.getCellAsText(row, column);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)hasText).overridingErrorMessage("expected not to find [" + text + "] in [" + actualText + "]", new Object[0])).isFalse();
    }

    public void assertTableCellHasImage(WebTable webTable, int row, int column, String stringInImageSource) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)new ImageCell(stringInImageSource).equals(webTable, row, column)).overridingErrorMessage("Expected image not found. Please see logs for details.", new Object[0])).isTrue();
    }

    public void assertTableCellHasNoImage(WebTable webTable, int row, int column) {
        Object[] webImages = webTable.getTableCell(row, column).getImages();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])webImages).overridingErrorMessage(() -> TableAssertions.lambda$assertTableCellHasNoImage$0((WebImage[])webImages))).isEmpty();
    }

    private int countNumRows(WebTable webTable, Object[] expectedRow) {
        return this.countNumRows(webTable, expectedRow, false);
    }

    private int countNumRows(WebTable webTable, Object[] expectedRow, boolean exactCellSearching) {
        int count = 0;
        for (int i = 0; i < webTable.getRowCount(); ++i) {
            if (!this.tableRowEquals(webTable, i, Arrays.asList(expectedRow), exactCellSearching)) continue;
            ++count;
        }
        return count;
    }

    private boolean tableRowEquals(WebTable table, int row, List expectedRow, boolean strictCellCheck) {
        TableCellChecker checker = strictCellCheck ? equalsChecker : containsChecker;
        return this.tableRowEquals(table, row, expectedRow, checker);
    }

    private boolean tableRowEquals(WebTable table, int row, List expectedRow, TableCellChecker tableCellChecker) {
        if (expectedRow.isEmpty()) {
            this.logger.log((Object)"expected row is empty");
            return false;
        }
        int maxCol = table.getColumnCount();
        for (int col = 0; col < expectedRow.size() && col < maxCol; ++col) {
            Object expectedCell = expectedRow.get(col);
            if (expectedCell == null) continue;
            if (expectedCell instanceof SimpleCell) {
                SimpleCell simpleCell = (SimpleCell)expectedCell;
                if (simpleCell.equals(table, row, col)) continue;
                String cellContent = simpleCell.getCellAsText(table, row, col);
                this.logger.log((Object)("table '" + table.getID() + "' row '" + row + "' does not match expected row because cell [" + row + ", " + col + "] = [" + cellContent + "] does not match [" + expectedCell.toString() + "]"));
                return false;
            }
            if (tableCellChecker.check(table, row, col, expectedCell.toString())) continue;
            String cellContent = table.getCellAsText(row, col).trim();
            this.logger.log((Object)("table '" + table.getID() + "' row '" + row + "' does not match expected row because cell [" + row + ", " + col + "] = [" + cellContent + "] does not match [" + expectedCell.toString() + "]"));
            return false;
        }
        return true;
    }

    private String rowToString(Object[] row) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < row.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append('\"');
            sb.append(row[i]);
            sb.append('\"');
        }
        return sb.toString();
    }

    private List<String> getTableRowAsList(WebTable table, int row) {
        ArrayList<String> tableRow = new ArrayList<String>();
        int maxCol = table.getColumnCount();
        for (int col = 0; col < maxCol; ++col) {
            tableRow.add(table.getCellAsText(row, col).trim());
        }
        return tableRow;
    }

    private static /* synthetic */ String lambda$assertTableCellHasNoImage$0(WebImage[] webImages) {
        return "An image was found in a cell where it wasn't expected. First image = '" + webImages[0].getSource() + "'.";
    }

    private static final class ContainsChecker
    implements TableCellChecker {
        private ContainsChecker() {
        }

        @Override
        public boolean check(WebTable table, int row, int col, String text) {
            return TextKit.containsCollapseWhiteSpace(text, table.getCellAsText(row, col));
        }
    }

    private static final class StrictWhitespaceContainsChecker
    implements TableCellChecker {
        private StrictWhitespaceContainsChecker() {
        }

        @Override
        public boolean check(WebTable table, int row, int col, String text) {
            String cellContent = table.getCellAsText(row, col);
            if ("".equals(text)) {
                return "".equals(cellContent.trim());
            }
            return cellContent.contains(text);
        }
    }

    private static final class EqualsChecker
    implements TableCellChecker {
        private EqualsChecker() {
        }

        @Override
        public boolean check(WebTable table, int row, int col, String text) {
            return TextKit.equalsCollapseWhiteSpace(text, table.getCellAsText(row, col));
        }
    }

    static interface TableCellChecker {
        public boolean check(WebTable var1, int var2, int var3, String var4);
    }
}

