/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.util.text.TextKit;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;

public class TextAssertionsImpl
implements TextAssertions {
    private final WebTester tester;

    public TextAssertionsImpl() {
        this.tester = null;
    }

    @Inject
    public TextAssertionsImpl(WebTester tester) {
        this.tester = tester;
    }

    @Override
    public void assertTextPresent(String expectedText) {
        if (!this.getFullResponseText().contains(expectedText)) {
            Fail.fail((String)("Expected text '" + expectedText + "' not found in the current page."));
        }
    }

    @Override
    public void assertTextPresentHtmlEncoded(String expectedText) {
        this.assertTextPresent(TextUtils.htmlEncode((String)expectedText, (boolean)false));
    }

    @Override
    public void assertTextNotPresent(String expectedText) {
        if (this.getFullResponseText().contains(expectedText)) {
            Fail.fail((String)("Text '" + expectedText + "' was found in the current page."));
        }
    }

    @Override
    public void assertTextPresent(Locator locator, String expectedText) {
        String srcText = locator == null ? this.getFullResponseText() : locator.getText();
        this.assertTextPresentImpl(locator, srcText, expectedText);
    }

    @Override
    public void assertTextPresent(String srcText, String expectedText) {
        this.assertTextPresentImpl(null, srcText, expectedText);
    }

    @Override
    public void assertTextPresentNumOccurences(String expectedText, int numOccurences) {
        this.assertTextPresentNumOccurences(this.getFullResponseText(), expectedText, numOccurences);
    }

    @Override
    public void assertTextPresentNumOccurences(String srcText, String subString, int expectedCount) {
        int count = TextKit.getNumOccurences(srcText, subString);
        if (count != expectedCount) {
            String occurrences = expectedCount == 1 ? " occurrence" : " occurrences";
            Fail.fail((String)("Expected to find exactly " + expectedCount + occurrences + " of '" + subString + "' but " + count + " were found."));
        }
    }

    @Override
    public void assertTextPresentNumOccurences(Locator locator, String expectedText, int numOccurences) {
        this.assertTextPresentNumOccurences(locator.getText(), expectedText, numOccurences);
    }

    private void assertTextPresentImpl(Locator locator, String srcText, String expectedText) {
        if (srcText == null) {
            Fail.fail((String)("The src text is null and hence:'" + expectedText + "' could not be found" + (locator == null ? "" : " via locator " + locator)));
        }
        if (srcText.indexOf(expectedText) == -1) {
            Fail.fail((String)("The text '" + expectedText + "' could not be found" + (locator == null ? "" : " via src '" + srcText + "' and locator " + locator)));
        }
    }

    @Override
    public void assertTextNotPresent(String srcText, String expectedText) {
        this.assertTextNotPresentImpl(null, srcText, expectedText);
    }

    @Override
    public void assertTextNotPresent(Locator locator, String expectedText) {
        this.assertTextNotPresentImpl(locator, locator.getText(), expectedText);
    }

    private void assertTextNotPresentImpl(Locator locator, String srcText, String expectedText) {
        if (srcText != null && srcText.indexOf(expectedText) != -1) {
            Fail.fail((String)("The text '" + expectedText + "' unexpectantly found" + (locator == null ? "" : " via locator " + locator)));
        }
    }

    @Override
    public void assertTextSequence(Locator locator, String[] expectedTextSequence) {
        this.assertTextSequence(locator.getText(), expectedTextSequence);
    }

    @Override
    public void assertTextSequence(Locator locator, String expected1, String ... expected2) {
        ArrayList<String> expected = new ArrayList<String>(Arrays.asList(expected2));
        expected.add(0, expected1);
        this.assertTextSequence(locator.getText(), expected.toArray(new String[expected.size()]));
    }

    @Override
    public void assertAtLeastOneTextPresent(Locator locator, String option1, String ... moreOptions) {
        ArrayList<String> options = new ArrayList<String>(Arrays.asList(moreOptions));
        options.add(0, option1);
        for (String option : options) {
            try {
                this.assertTextPresent(locator, option);
                return;
            }
            catch (AssertionError assertionError) {
            }
        }
        Fail.fail((String)("The none of the text strings in " + ((Object)options).toString() + "' could not be found" + (locator == null ? "" : " via locator " + locator)));
    }

    @Override
    public void assertEqualDateStrings(String expected, String actual) {
        String[] expected_split = expected.split("(\\+|\\-)\\d{4}$");
        String[] actual_split = actual.split("(\\+|\\-)\\d{4}$");
        Assertions.assertThat((String)actual_split[0]).isEqualTo(expected_split[0]);
    }

    @Override
    public void assertTextSequence(String srcText, String expected1, String ... expected2) {
        ArrayList<String> expected = new ArrayList<String>(Arrays.asList(expected2));
        expected.add(0, expected1);
        this.assertTextSequence(srcText, expected.toArray(new String[expected.size()]));
    }

    @Override
    public void assertTextSequence(String srcText, String[] expectedTextSequence) {
        TextKit.assertContainsTextSequence(srcText, expectedTextSequence);
    }

    private void assertRegexImpl(Locator locator, String srcText, String regexPattern, boolean postiveMatchBehaviour) {
        Pattern pattern = Pattern.compile(regexPattern, 8);
        Matcher matcher = pattern.matcher(srcText);
        boolean matches = matcher.find();
        if (postiveMatchBehaviour) {
            if (!matches) {
                Fail.fail((String)("The regex '" + regexPattern + "' did not have any matches" + (locator == null ? "" : " via locator " + locator)));
            }
        } else if (matches) {
            Fail.fail((String)("The regex '" + regexPattern + "' unexpectantly has some matches" + (locator == null ? "" : " via locator " + locator)));
        }
    }

    @Override
    public void assertRegexMatch(String srcText, String regexPattern) {
        this.assertRegexImpl(null, srcText, regexPattern, true);
    }

    @Override
    public void assertRegexNoMatch(String srcText, String regexPattern) {
        this.assertRegexImpl(null, srcText, regexPattern, false);
    }

    @Override
    public void assertRegexMatch(Locator locator, String regexPattern) {
        this.assertRegexImpl(locator, locator.getText(), regexPattern, true);
    }

    @Override
    public void assertRegexNoMatch(Locator locator, String regexPattern) {
        this.assertRegexImpl(locator, locator.getText(), regexPattern, false);
    }

    private String getFullResponseText() {
        return this.tester.getDialog().getResponseText();
    }
}

