/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.testkit.client.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericType;

public class AnalyticsEventsControl
extends BackdoorControl<AnalyticsEventsControl> {
    public AnalyticsEventsControl(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
        super((JIRAEnvironmentData)environmentData);
    }

    protected String getRestModulePath() {
        return "analytics";
    }

    public AnalyticsEventsControl clear() {
        this.createResource().path("report").request().delete();
        return this;
    }

    public AnalyticsEventsControl publish(BrowserEventBean browserEventBean) {
        this.createResource().path("/publish").request().post(Entity.json((Object)browserEventBean), String.class);
        return this;
    }

    public AnalyticsEventsControl enable() {
        return this.setEnabled(true);
    }

    public AnalyticsEventsControl disable() {
        return this.setEnabled(false);
    }

    public AnalyticsEventsControl acknowledgePrivacyPolicy() {
        this.createResource().path("config/acknowledge").request().put(Entity.text((Object)""), String.class);
        return this;
    }

    public AnalyticsEventsControl setEnabled(boolean enabled) {
        if (enabled) {
            this.acknowledgePrivacyPolicy();
        }
        this.createResource().path("config/enable").request(new String[]{"application/json"}).put(Entity.json((Object)ImmutableMap.of((Object)"analyticsEnabled", (Object)enabled)), String.class);
        this.createResource().path("report").request(new String[]{"application/json"}).put(Entity.json((Object)ImmutableMap.of((Object)"capturing", (Object)Boolean.toString(enabled))), String.class);
        return this;
    }

    public List<Map<?, ?>> getEvents() {
        return (List)((Map)this.createResource().path("report").queryParam("mode", new Object[]{"btf_processed"}).request().get(new GenericType<Map<?, ?>>(){})).get("events");
    }

    public List<Map<?, ?>> matchEvents(String name) {
        return (List)this.getEvents().stream().filter(event -> event.get("removed").equals(false) && event.get("name").equals(name)).collect(CollectorsUtil.toImmutableList());
    }

    public boolean hasEventWithKeyProperty(String name, String key) {
        return this.getEventWithKeyProperty(name, key).isPresent();
    }

    public Optional<Map<?, ?>> getEventWithKeyProperty(String name, String key) {
        return this.matchEvents(name).stream().filter(event -> {
            Map eventProperties = (Map)event.get("properties");
            String eventKey = (String)eventProperties.get("key");
            return eventKey.equals(key);
        }).findFirst();
    }

    public Map<?, ?> getEventProperties(Map<?, ?> event) {
        return (Map)event.get("properties");
    }

    public String getEventProperty(Map<?, ?> event, String property) {
        return (String)this.getEventProperties(event).get(property);
    }

    public boolean isEnabled() {
        String response = (String)this.resourceRoot(this.rootPath).path("plugins/servlet/analytics/configuration").request().get(String.class);
        String configLine = Arrays.stream(response.split("\n")).filter(line -> line.contains("id=\"enable-analytics\"")).findAny().orElse("");
        return configLine.contains(" checked");
    }

    public static class BrowserEventBean {
        @JsonProperty
        String name;
        @JsonProperty
        Map<String, Object> properties;
        @JsonProperty
        long timeDelta;

        public BrowserEventBean() {
        }

        public BrowserEventBean(String name, Map<String, Object> properties, long timeDelta) {
            this.name = name;
            this.properties = properties;
            this.timeDelta = timeDelta;
        }
    }
}

