/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ApplicationRoleControl
extends RestApiClient<ApplicationRoleControl> {
    public ApplicationRoleControl(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
        super((JIRAEnvironmentData)environmentData);
    }

    public List<ApplicationRoleBean> getRoles() {
        return (List)this.createApplicationRoleResource().request().get(ApplicationRoleBean.LIST);
    }

    public Map<String, ApplicationRoleBean> getRolesMap() {
        return Maps.uniqueIndex(this.getRoles(), (Function)ApplicationRoleBean.GET_KEY);
    }

    public ParsedResponse<List<ApplicationRoleBean>> getRolesResponse() {
        return this.toResponse(() -> (Response)this.createApplicationRoleResource().request().get(Response.class), ApplicationRoleBean.LIST);
    }

    public ApplicationRoleBean getRole(String role) {
        return (ApplicationRoleBean)this.createApplicationRoleResource().path(role).request().get(ApplicationRoleBean.class);
    }

    public ApplicationRoleBean getCore() {
        return this.getRole("jira-core");
    }

    public ApplicationRoleBean getSoftware() {
        return this.getRole("jira-software");
    }

    public ParsedResponse<ApplicationRoleBean> getRoleResponse(String role) {
        return this.toResponse(() -> (Response)this.createApplicationRoleResource().path(role).request().get(Response.class), ApplicationRoleBean.class);
    }

    public ApplicationRoleBean putRole(String role, String ... groups) {
        return (ApplicationRoleBean)this.createApplicationRoleResource().path(role).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)new ApplicationRoleBean(groups)), ApplicationRoleBean.class);
    }

    public ApplicationRoleBean putRoleWithDefaults(String role, Iterable<String> groups, Iterable<String> defaultGroups) {
        return (ApplicationRoleBean)this.createApplicationRoleResource().path(role).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)new ApplicationRoleBean(groups).setDefaultGroups((List<String>)ImmutableList.copyOf(defaultGroups))), ApplicationRoleBean.class);
    }

    public ApplicationRoleBean putRoleSelectedByDefault(String role, boolean selectedByDefault) {
        return (ApplicationRoleBean)this.createApplicationRoleResource().path(role).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)new ApplicationRoleBean(selectedByDefault)), ApplicationRoleBean.class);
    }

    public ApplicationRoleBean putRoleWithDefaultsSelectedByDefault(String role, boolean selectedByDefault, Iterable<String> groups, Iterable<String> defaultGroups) {
        return (ApplicationRoleBean)this.createApplicationRoleResource().path(role).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)new ApplicationRoleBean(groups).setSelectedByDefault(selectedByDefault).setDefaultGroups((List<String>)ImmutableList.copyOf(defaultGroups))), ApplicationRoleBean.class);
    }

    public ApplicationRoleBean putRoleAndSetDefault(String role, String group) {
        return this.putRoleWithDefaults(role, Collections.singleton(group), Collections.singleton(group));
    }

    public ParsedResponse<ApplicationRoleBean> putRoleResponse(String role, String ... groups) {
        return this.toResponse(() -> (Response)this.createApplicationRoleResource().path(role).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)new ApplicationRoleBean(groups)), Response.class), ApplicationRoleBean.class);
    }

    public ParsedResponse<ApplicationRoleBean> putSelectedByDefaultResponse(String role, boolean selectedByDefault) {
        return this.toResponse(() -> (Response)this.createApplicationRoleResource().path(role).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)new ApplicationRoleBean(selectedByDefault)), Response.class), ApplicationRoleBean.class);
    }

    private WebTarget createApplicationRoleResource() {
        return this.createResource().path("applicationrole");
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ApplicationRoleBean {
        private static final GenericType<List<ApplicationRoleBean>> LIST = new GenericType<List<ApplicationRoleBean>>(){};
        private static final Function<ApplicationRoleBean, String> GET_KEY = new Function<ApplicationRoleBean, String>(){

            public String apply(ApplicationRoleBean input) {
                return input.key;
            }
        };
        @JsonProperty
        private String name;
        @JsonProperty
        private String key;
        @JsonProperty
        private List<String> groups;
        @JsonProperty
        private List<String> defaultGroups;
        @JsonProperty
        private boolean selectedByDefault;
        @JsonProperty
        private Integer numberOfSeats;
        @JsonProperty
        private Integer remainingSeats;
        @JsonProperty
        private Integer userCount;
        @JsonProperty
        private Boolean hasUnlimitedSeats;

        public ApplicationRoleBean() {
            this.groups = Lists.newArrayList();
        }

        private ApplicationRoleBean(String ... groups) {
            this.groups = ImmutableList.copyOf((Object[])groups);
        }

        private ApplicationRoleBean(Iterable<String> groups) {
            this.groups = ImmutableList.copyOf(groups);
        }

        private ApplicationRoleBean(boolean selectedByDefault) {
            this.selectedByDefault = selectedByDefault;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("id", (Object)this.key).append("groups", this.groups).append("selectedByDefault", this.selectedByDefault).append("numberOfSeats", (Object)this.numberOfSeats).append("remainingSeats", (Object)this.remainingSeats).append("userCount", (Object)this.userCount).append("hasUnlimitedSeats", (Object)this.hasUnlimitedSeats).toString();
        }

        public String getName() {
            return this.name;
        }

        public String getKey() {
            return this.key;
        }

        public List<String> getGroups() {
            return this.groups;
        }

        public List<String> getDefaultGroups() {
            return this.defaultGroups;
        }

        public boolean isSelectedByDefault() {
            return this.selectedByDefault;
        }

        public Integer getNumberOfSeats() {
            return this.numberOfSeats;
        }

        public Integer getRemainingSeats() {
            return this.remainingSeats;
        }

        public Integer getUserCount() {
            return this.userCount;
        }

        public Boolean getHasUnlimitedSeats() {
            return this.hasUnlimitedSeats;
        }

        public ApplicationRoleBean setDefaultGroups(List<String> defaultGroups) {
            this.defaultGroups = ImmutableList.copyOf(defaultGroups);
            return this;
        }

        public ApplicationRoleBean setSelectedByDefault(boolean selectedByDefault) {
            this.selectedByDefault = selectedByDefault;
            return this;
        }

        public ApplicationRoleBean setNumberOfSeats(Integer numberOfSeats) {
            this.numberOfSeats = numberOfSeats;
            return this;
        }

        public ApplicationRoleBean setRemainingSeats(Integer remainingSeats) {
            this.remainingSeats = remainingSeats;
            return this;
        }

        public ApplicationRoleBean setUserCount(Integer userCount) {
            this.userCount = userCount;
            return this;
        }

        public ApplicationRoleBean setHasUnlimitedSeats(boolean hasUnlimitedSeats) {
            this.hasUnlimitedSeats = hasUnlimitedSeats;
            return this;
        }
    }
}

