/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.functest.framework.backdoor.BackdoorControl;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;

public class BarrierControl
extends BackdoorControl<BarrierControl> {
    public BarrierControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public void raiseBarrierAndRun(String barrierName, Runnable r) {
        this.raise(barrierName);
        try {
            r.run();
        }
        finally {
            this.lower(barrierName);
        }
    }

    public void raiseBarrierAndRun(String barrierName, BarrierFunction function) {
        this.raise(barrierName);
        try {
            function.run(new Barrier(barrierName));
        }
        finally {
            this.lower(barrierName);
        }
    }

    private void raise(String barrierName) {
        this.createResource().path("barrier").path("raise").queryParam("barrierName", new Object[]{barrierName}).request().post(null, String.class);
    }

    private void lower(String barrierName) {
        this.createResource().path("barrier").path("lower").queryParam("barrierName", new Object[]{barrierName}).request().post(null, String.class);
    }

    public static interface BarrierFunction {
        public void run(Barrier var1);
    }

    public class Barrier {
        private String barrierName;

        public Barrier(String barrierName) {
            this.barrierName = barrierName;
        }

        public void lowerThenRaise() {
            BarrierControl.this.createResource().path("barrier").path("lowerThenRaise").queryParam("barrierName", new Object[]{this.barrierName}).request().post(null, String.class);
        }
    }
}

