/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.functest.framework.backdoor.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;

public class DatabaseMaintenanceControl
extends BackdoorControl<DatabaseMaintenanceControl> {
    public DatabaseMaintenanceControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public List<IndexMetadata> getIndexMetadata(String tableName) {
        return (List)this.createIndexesResource().path(tableName).request().get((GenericType)new GenericType<List<IndexMetadata>>(){});
    }

    public void createIndex(String entityName, String tableName, String indexName, boolean unique, ImmutableMap<String, String> fieldNameToColumnName) {
        this.createIndexesResource().request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)new CreateIndexBean(entityName, tableName, indexName, unique, fieldNameToColumnName)), String.class);
    }

    public void dropIndex(String tableName, String indexName) {
        this.createIndexesResource().path(tableName).path(indexName).request().delete();
    }

    protected WebTarget createIndexesResource() {
        return this.createResource().path("databaseMaintenance").path("indexes");
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateIndexBean {
        @JsonProperty
        String entityName;
        @JsonProperty
        String tableName;
        @JsonProperty
        String indexName;
        @JsonProperty
        boolean unique;
        @JsonProperty
        Map<String, String> fieldNameToColumnName;

        CreateIndexBean() {
        }

        public CreateIndexBean(String entityName, String tableName, String indexName, boolean unique, ImmutableMap<String, String> fieldNameToColumnName) {
            this.entityName = entityName;
            this.tableName = tableName;
            this.indexName = indexName;
            this.unique = unique;
            this.fieldNameToColumnName = fieldNameToColumnName;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class IndexMetadata {
        @JsonProperty
        public String indexName;
        @JsonProperty
        public boolean isUnique;
        @JsonProperty
        public List<String> columns;
    }
}

