/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.functest.framework.backdoor.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;

public class EntityVersioningControl
extends BackdoorControl<EntityVersioningControl> {
    private static final String PATH_ISSUE = "issue";
    private static final String PATH_COMMENT = "comment";
    private static final String PATH_WORKLOG = "worklog";
    private static final String PATH_CHANGEHISTORY = "changehistory";

    public EntityVersioningControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public List<EntityVersionBean> getAllIssueVersions() {
        return this.getAllVersions(PATH_ISSUE);
    }

    public List<EntityVersionBean> getAllCommentVersions() {
        return this.getAllVersions(PATH_COMMENT);
    }

    public List<EntityVersionBean> getAllWorklogVersions() {
        return this.getAllVersions(PATH_WORKLOG);
    }

    private List<EntityVersionBean> getAllVersions(String entityPath) {
        return (List)this.createEntityVersionTarget().path(entityPath).request().get((GenericType)new GenericType<List<EntityVersionBean>>(){});
    }

    public void incrementIssueVersion(Long issueId) {
        this.createIncrementTarget(PATH_ISSUE, issueId).request().put(Entity.text((Object)""), String.class);
    }

    public void incrementCommentVersion(Long commentId, Long parentIssueId) {
        this.createIncrementTarget(PATH_COMMENT, commentId).queryParam("parentIssueId", new Object[]{Long.toString(parentIssueId)}).request().put(Entity.text((Object)""), String.class);
    }

    public void incrementWorklogVersion(Long worklogId, Long parentIssueId) {
        this.createIncrementTarget(PATH_WORKLOG, worklogId).queryParam("parentIssueId", new Object[]{Long.toString(parentIssueId)}).request().put(Entity.text((Object)""), String.class);
    }

    private WebTarget createIncrementTarget(String entityPath, Long entityId) {
        return this.createEntityVersionTarget().path(entityPath).path(Long.toString(entityId)).path("increment");
    }

    public void markIssueDeletedAndUpdateVersion(Long issueId) {
        this.markDeletedAndUpdateVersion(PATH_ISSUE, issueId);
    }

    public void markCommentDeletedAndUpdateVersion(Long commentId) {
        this.markDeletedAndUpdateVersion(PATH_COMMENT, commentId);
    }

    public void markWorklogDeletedAndUpdateVersion(Long worklogId) {
        this.markDeletedAndUpdateVersion(PATH_WORKLOG, worklogId);
    }

    private void markDeletedAndUpdateVersion(String entityPath, Long entityId) {
        this.createEntityVersionTarget().path(entityPath).path(Long.toString(entityId)).path("markDeleted").request().put(Entity.text((Object)""), String.class);
    }

    public void incrementCommentVersionsRelatedToIssue(long issueId) {
        this.incrementRelated(PATH_COMMENT, issueId);
    }

    public void incrementWorklogVersionsRelatedToIssue(long issueId) {
        this.incrementRelated(PATH_WORKLOG, issueId);
    }

    private void incrementRelated(String entityPath, long issueId) {
        this.createEntityVersionTarget().path("related").path(entityPath).path(Long.toString(issueId)).request().put(Entity.text((Object)""), String.class);
    }

    public Optional<Long> getIssueVersion(Long issueId) {
        return this.getVersion(PATH_ISSUE, issueId, false);
    }

    public Optional<Long> getCommentVersion(Long commentId) {
        return this.getVersion(PATH_COMMENT, commentId, false);
    }

    public Optional<Long> getWorklogVersion(Long worklogId) {
        return this.getVersion(PATH_WORKLOG, worklogId, false);
    }

    public Optional<Long> getLocalIssueVersion(Long issueId) {
        return this.getVersion(PATH_ISSUE, issueId, true);
    }

    public Optional<Long> getLocalCommentVersion(Long commentId) {
        return this.getVersion(PATH_COMMENT, commentId, true);
    }

    public Optional<Long> getLocalWorklogVersion(Long worklogId) {
        return this.getVersion(PATH_WORKLOG, worklogId, true);
    }

    public Optional<Long> getLocalChangeHistoryVersion(Long issueId) {
        return this.getVersion(PATH_CHANGEHISTORY, issueId, true);
    }

    private Optional<Long> getVersion(String entityPath, Long entityId, boolean localVersion) {
        WebTarget path = this.createEntityVersionTarget().path(entityPath).path(Long.toString(entityId));
        if (localVersion) {
            path = path.path("localVersion");
        }
        EntityVersionBean entityVersionBean = (EntityVersionBean)path.request().get(EntityVersionBean.class);
        if (entityVersionBean.hasVersion) {
            return Optional.of(entityVersionBean.entityVersion);
        }
        return Optional.empty();
    }

    public Map<Long, Long> getRelatedCommentVersions(long issueId) {
        return this.getRelatedVersions(PATH_COMMENT, issueId);
    }

    public Map<Long, Long> getRelatedWorklogVersions(long issueId) {
        return this.getRelatedVersions(PATH_WORKLOG, issueId);
    }

    private Map<Long, Long> getRelatedVersions(String entityPath, long issueId) {
        return (Map)this.createEntityVersionTarget().path("related").path(entityPath).path(Long.toString(issueId)).request().get((GenericType)new GenericType<Map<Long, Long>>(){});
    }

    public void createNewIssueVersionRow(long issueId, LocalDateTime updateTime, long version, boolean deleted) {
        this.createNewVersionRowResource(PATH_ISSUE, issueId, EntityVersionBean.newIssueVersionBean(issueId, PATH_ISSUE, updateTime, version, deleted));
    }

    public void createNewCommentVersionRow(long commentId, long parentIssueId, LocalDateTime updateTime, long version, boolean deleted) {
        this.createNewVersionRowResource(PATH_COMMENT, commentId, EntityVersionBean.newRelatedEntityVersionBean(commentId, parentIssueId, PATH_COMMENT, updateTime, version, deleted));
    }

    public void createNewWorklogVersionRow(long worklogId, long parentIssueId, LocalDateTime updateTime, long version, boolean deleted) {
        this.createNewVersionRowResource(PATH_WORKLOG, worklogId, EntityVersionBean.newRelatedEntityVersionBean(worklogId, parentIssueId, PATH_WORKLOG, updateTime, version, deleted));
    }

    private void createNewVersionRowResource(String entityPath, long entityId, EntityVersionBean versionBean) {
        WebTarget resource = this.createEntityVersionTarget().path(entityPath).path(Long.toString(entityId));
        if (versionBean.hasParentIssue()) {
            resource = resource.queryParam("parentIssueId", new Object[]{Long.toString(versionBean.parentIssueId)});
        }
        resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)versionBean), String.class);
    }

    public void cleanAllDeletedEntityVersionsOlderThan(Duration duration) {
        this.createEntityVersionTarget().path("cleanAllDeleted").queryParam("ageThresholdSeconds", new Object[]{Long.toString(duration.getSeconds())}).request().delete();
    }

    private WebTarget createEntityVersionTarget() {
        return this.createResource().path("entityVersioning");
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class EntityVersionBean {
        @JsonProperty
        public Long entityId;
        @JsonProperty
        public Long parentIssueId;
        @JsonProperty
        public String entityType;
        @JsonProperty
        public Timestamp updateTime;
        @JsonProperty
        public Long entityVersion;
        @JsonProperty
        public boolean hasVersion;
        @JsonProperty
        public boolean deleted;

        public EntityVersionBean() {
        }

        EntityVersionBean(Long entityId, Long parentIssueId, String entityType, Timestamp updateTime, Long entityVersion, boolean hasVersion, boolean deleted) {
            this.entityId = entityId;
            this.parentIssueId = parentIssueId;
            this.entityType = entityType;
            this.updateTime = updateTime;
            this.entityVersion = entityVersion;
            this.hasVersion = hasVersion;
            this.deleted = deleted;
        }

        static EntityVersionBean newIssueVersionBean(Long entityId, String entityType, LocalDateTime updateTime, Long entityVersion, boolean deleted) {
            return new EntityVersionBean(entityId, null, entityType, Timestamp.valueOf(updateTime), entityVersion, true, deleted);
        }

        static EntityVersionBean newRelatedEntityVersionBean(Long entityId, Long parentIssueId, String entityType, LocalDateTime updateTime, Long entityVersion, boolean deleted) {
            return new EntityVersionBean(entityId, parentIssueId, entityType, Timestamp.valueOf(updateTime), entityVersion, true, deleted);
        }

        boolean hasParentIssue() {
            return this.parentIssueId != null;
        }

        public String toString() {
            return "EntityVersionBean{entityId=" + this.entityId + ", parentIssueId=" + this.parentIssueId + ", entityType=" + this.entityType + ", updateTime=" + this.updateTime + ", entityVersion=" + this.entityVersion + ", hasVersion=" + this.hasVersion + ", deleted=" + this.deleted + '}';
        }
    }
}

