/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.functest.framework.backdoor.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.ws.rs.client.WebTarget;

public class EventClient
extends BackdoorControl<EventClient> {
    public EventClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public EventPoller createPoller() {
        EventData data = this.getEventsAtPos(-1);
        return new EventPoller(data.position());
    }

    public void stopAllPollers() {
        this.createEventResource().request().delete();
    }

    private EventData getEventsAtPos(int position) {
        return (EventData)this.createEventResource().queryParam("position", new Object[]{String.valueOf(position)}).request().get(EventData.class);
    }

    private WebTarget createEventResource() {
        return this.createResource().path("event");
    }

    public static class EventData {
        private final List<String> events;
        private final int position;

        @JsonCreator
        public EventData(@JsonProperty(value="events") List<String> events, @JsonProperty(value="position") int position) {
            this.events = ImmutableList.copyOf(events);
            this.position = position;
        }

        private List<String> events() {
            return this.events;
        }

        private int position() {
            return this.position;
        }

        private int nextPosition() {
            return this.position + this.events.size();
        }

        public String toString() {
            return "EventData{events=" + this.events + ", position=" + this.position + '}';
        }
    }

    public class EventPoller {
        private int position;

        private EventPoller(int position) {
            this.position = position;
        }

        public Iterable<String> events() {
            EventData data = EventClient.this.getEventsAtPos(this.position);
            if (data.position != this.position) {
                if (data.position > this.position) {
                    throw new IllegalStateException(String.format("%d events got dropped. Received event data: %s", data.position - this.position, data));
                }
                throw new IllegalStateException("Asking for events that don't exist yet.");
            }
            this.position = data.nextPosition();
            return data.events();
        }
    }
}

