/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.functest.framework.backdoor.BackdoorControl;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeJsonBean;
import com.atlassian.jira.rest.internal.v2.field.configscheme.FieldConfigSchemeBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.IssueTypeClient;
import com.atlassian.jira.testkit.client.restclient.ProjectClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;

public class FieldConfigSchemeControl
extends BackdoorControl<FieldConfigSchemeControl> {
    private final IssueTypeClient issueTypeClient;
    private final ProjectClient projectClient;

    public FieldConfigSchemeControl(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
        super(environmentData);
        this.issueTypeClient = new IssueTypeClient((JIRAEnvironmentData)environmentData);
        this.projectClient = new ProjectClient((JIRAEnvironmentData)environmentData);
    }

    public void updateFieldConfigScheme(@Nonnull String fieldId, long configSchemeId, @Nullable String label, @Nullable Collection<String> projectIds, @Nullable Collection<String> issueTypeIds) {
        Collection selectedIssueTypes = this.convertIssueTypeIdsToJsonBeans(issueTypeIds);
        Collection selectedProjects = this.convertProjectIdsToJsonBeans(projectIds);
        FieldConfigSchemeBean currentScheme = (FieldConfigSchemeBean)this.createFieldConfigSchemeResource(fieldId).path(String.valueOf(configSchemeId)).request().get(FieldConfigSchemeBean.class);
        FieldConfigSchemeBean bean = FieldConfigSchemeBean.builder().setSelf(currentScheme.getSelf()).setId(currentScheme.getId()).setDescription(currentScheme.getDescription()).setField(currentScheme.getField()).setDefaultValue(currentScheme.getDefaultValue()).setName(label == null ? currentScheme.getName() : label).setIssueTypes(issueTypeIds == null ? currentScheme.getIssueTypes() : selectedIssueTypes).setAllIssueTypes(issueTypeIds == null ? currentScheme.isAllIssueTypes() : selectedIssueTypes.isEmpty()).setProjects(projectIds == null ? currentScheme.getProjects() : selectedProjects).setAllProjects(projectIds == null ? currentScheme.isAllProjects() : selectedProjects.isEmpty()).build();
        this.createFieldConfigSchemeResource(fieldId).path(String.valueOf(configSchemeId)).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)bean), FieldConfigSchemeBean.class);
    }

    private WebTarget createFieldConfigSchemeResource(String fieldId) {
        return this.createResource().path("field").path(fieldId).path("context");
    }

    private Collection<IssueTypeJsonBean> convertIssueTypeIdsToJsonBeans(Collection<String> issueTypeIds) {
        List allIssueTypes = this.issueTypeClient.get();
        if (issueTypeIds != null) {
            return allIssueTypes.stream().filter(it -> issueTypeIds.contains(it.id)).map(it -> IssueTypeJsonBean.shortBean((String)it.self, (String)it.id, (String)it.name, (String)it.description, (boolean)it.subtask, (Long)it.avatarId, (String)it.iconUrl)).collect(Collectors.toList());
        }
        return new ArrayList<IssueTypeJsonBean>();
    }

    private Collection<ProjectBean> convertProjectIdsToJsonBeans(Collection<String> projectIds) {
        List allProjects = this.projectClient.getProjects();
        if (projectIds != null) {
            return allProjects.stream().filter(it -> projectIds.contains(it.id)).map(it -> ProjectBean.fromId((String)it.id)).collect(Collectors.toList());
        }
        return new ArrayList<ProjectBean>();
    }

    @Override
    protected WebTarget createResource() {
        return this.resourceRoot(this.rootPath).path("rest").path("internal").path("2");
    }
}

