/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.functest.framework.backdoor.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.meterware.httpunit.WebResponse;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;

public class IssuesControl
extends BackdoorControl<IssuesControl> {
    public static final String LIST_VIEW_LAYOUT = "list-view";

    public IssuesControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public String getIssueKeyForSummary(String summary) {
        return this.get(this.createResource().path("issues/issueKeyForSummary").queryParam("summary", new Object[]{summary}));
    }

    public String getIssueIdByCurrentKey(String key) {
        return this.get(this.createResource().path("issues/issueIdByKey").queryParam("key", new Object[]{key}));
    }

    public String getExportOptions(String jql, String filterId, String modified) {
        MultivaluedHashMap params = new MultivaluedHashMap();
        if (jql != null) {
            params.add((Object)"jql", (Object)jql);
        }
        if (filterId != null) {
            params.add((Object)"filterId", (Object)filterId);
        }
        if (modified != null) {
            params.add((Object)"modified", (Object)modified);
        }
        WebTarget target = this.resourceRoot(this.rootPath).path("rest/issueNav/1/issueNav/operations/views");
        return (String)target.request().header("X-Atlassian-Token", (Object)"no-check").post(Entity.form((MultivaluedMap)params), String.class);
    }

    public void setPreferredSearchLayout(String layoutKey, String username) {
        this.loginAs(username);
        WebTarget resource = this.resourceRoot(this.rootPath).path("rest/issueNav/latest/preferredSearchLayout");
        MultivaluedHashMap parameters = new MultivaluedHashMap();
        parameters.add((Object)"layoutKey", (Object)layoutKey);
        resource.request().header("X-Atlassian-Token", (Object)"no-check").post(Entity.form((MultivaluedMap)parameters), String.class);
    }

    public void touch(String key) {
        this.put(this.createResource().path("issues/touch").queryParam("key", new Object[]{key}));
    }

    public void changeArchivedDate(String key, Date date) {
        this.put(this.createResource().path("issues/changeArchivedDate").queryParam("key", new Object[]{key}).queryParam("date", new Object[]{String.valueOf(date.getTime())}));
    }

    public void changeUpdatedDateWithoutReindex(String key, Instant date) {
        this.put(this.createResource().path("issues/changeUpdatedDateWithoutReindex").queryParam("key", new Object[]{key}).queryParam("date", new Object[]{String.valueOf(date.toEpochMilli())}));
    }

    public WebResponse vote(String keyOrId) {
        return (WebResponse)this.resourceRoot(this.rootPath).path(String.format("rest/api/2/issue/%s/votes", keyOrId)).request().post(Entity.json(null), WebResponse.class);
    }

    public WebResponse watch(String keyOrId) {
        return (WebResponse)this.resourceRoot(this.rootPath).path(String.format("rest/api/2/issue/%s/watchers", keyOrId)).request().post(Entity.json(null), WebResponse.class);
    }

    private void put(WebTarget webResource) {
        webResource.request().put(Entity.json(null), String.class);
    }

    public List<JsonNode> getHistoryMetadata(String issueKey) {
        ArrayNode histories = this.getChangeLogHistories(issueKey);
        return ImmutableList.copyOf((Iterator)Iterators.transform((Iterator)histories.elements(), input -> input.get("historyMetadata")));
    }

    public List<Timestamp> getHistoryTimestamp(String issueKey) {
        ArrayNode histories = this.getChangeLogHistories(issueKey);
        return ImmutableList.copyOf((Iterator)Iterators.transform((Iterator)histories.elements(), input -> Timestamp.valueOf(input.get("created").toString().replace("\"", "").split("\\+")[0].replace("T", " "))));
    }

    private ArrayNode getChangeLogHistories(String issueKey) {
        return (ArrayNode)((JsonNode)this.resourceRoot(this.rootPath).path("rest/api/2/issue").path(issueKey).queryParam("expand", new Object[]{"changelog"}).request(new String[]{"application/json"}).get(JsonNode.class)).get("changelog").get("histories");
    }
}

