/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.functest.framework.backdoor.BackdoorControl;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;

public class ManagedConfigurationControl
extends BackdoorControl<ManagedConfigurationControl> {
    public ManagedConfigurationControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public List<ManagedEntity> getManagedCustomFields() {
        return (List)this.get(this.createCustomFieldsResource(), ManagedEntity.LIST);
    }

    public ManagedEntity getManagedCustomField(String customFieldId) {
        return this.get(this.createCustomFieldsResource().path(customFieldId), ManagedEntity.class);
    }

    public ManagedEntity postManagedCustomField(String customFieldId, boolean isManaged, boolean isLocked) {
        RegisterEntityHolder registerEntityHolder = new RegisterEntityHolder(isManaged, isLocked);
        return this.post(this.createCustomFieldsResource().path(customFieldId), registerEntityHolder, ManagedEntity.class);
    }

    public List<ManagedEntity> getManagedWorkflows() {
        return (List)this.get(this.createWorkflowsResource(), ManagedEntity.LIST);
    }

    public ManagedEntity getManagedWorkflow(String workflowName) {
        return this.get(this.createWorkflowsResource().path(workflowName), ManagedEntity.class);
    }

    public ManagedEntity postManagedWorkflow(String workflowName, boolean isManaged, boolean isLocked) {
        RegisterEntityHolder registerEntityHolder = new RegisterEntityHolder(isManaged, isLocked);
        return this.post(this.createWorkflowsResource().path(workflowName), registerEntityHolder, ManagedEntity.class);
    }

    public List<ManagedEntity> getManagedWorkflowSchemes() {
        return (List)this.get(this.createWorkflowSchemesResource(), ManagedEntity.LIST);
    }

    public ManagedEntity getManagedWorkflowScheme(String workflowSchemeName) {
        return this.get(this.createWorkflowSchemesResource().path(workflowSchemeName), ManagedEntity.class);
    }

    public ManagedEntity postManagedWorkflowScheme(String workflowSchemeName, boolean isManaged, boolean isLocked) {
        RegisterEntityHolder registerEntityHolder = new RegisterEntityHolder(isManaged, isLocked);
        return this.post(this.createWorkflowSchemesResource().path(workflowSchemeName), registerEntityHolder, ManagedEntity.class);
    }

    private <T> T get(WebTarget resource, Class<T> returnType) {
        return (T)resource.request().get(returnType);
    }

    private <T> T get(WebTarget resource, GenericType<T> returnType) {
        return (T)resource.request().get(returnType);
    }

    private <T> T post(WebTarget resource, Object object, Class<T> returnType) {
        return (T)resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)object), returnType);
    }

    private WebTarget createCustomFieldsResource() {
        return this.createManagedConfigurationResource().path("customfields");
    }

    private WebTarget createWorkflowsResource() {
        return this.createManagedConfigurationResource().path("workflows");
    }

    private WebTarget createWorkflowSchemesResource() {
        return this.createManagedConfigurationResource().path("workflowschemes");
    }

    private WebTarget createManagedConfigurationResource() {
        return this.createResource().path("managedconfiguration");
    }

    private static class RegisterEntityHolder {
        public boolean isManaged;
        public boolean isLocked;

        private RegisterEntityHolder(boolean managed, boolean locked) {
            this.isManaged = managed;
            this.isLocked = locked;
        }
    }

    public static class ManagedEntity {
        private static final GenericType<List<ManagedEntity>> LIST = new GenericType<List<ManagedEntity>>(){};
        private String itemId;
        private String itemType;
        private boolean isManaged;
        private boolean isLocked;

        public ManagedEntity() {
        }

        public ManagedEntity(String itemId, String itemType, boolean isManaged, boolean isLocked) {
            this.itemId = itemId;
            this.itemType = itemType;
            this.isManaged = isManaged;
            this.isLocked = isLocked;
        }

        public String getItemId() {
            return this.itemId;
        }

        public String getItemType() {
            return this.itemType;
        }

        public boolean isManaged() {
            return this.isManaged;
        }

        public boolean isLocked() {
            return this.isLocked;
        }

        public void setItemId(String itemId) {
            this.itemId = itemId;
        }

        public void setItemType(String itemType) {
            this.itemType = itemType;
        }

        public void setIsManaged(boolean isManaged) {
            this.isManaged = isManaged;
        }

        public void setIsLocked(boolean isLocked) {
            this.isLocked = isLocked;
        }
    }
}

