/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.PluginsControl;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlRootElement;

@ParametersAreNonnullByDefault
public class PluginsControlExt
extends PluginsControl {
    private static final String GET_UPM_TOKEN_MIME_TYPE = "application/vnd.atl.plugins.installed+json";
    private static final String UPLOAD_PLUGIN_MIME_TYPE = "application/vnd.atl.plugins.install.uri+json";
    private static final String ISSUE_NAV_PLUGIN_KEY = "com.atlassian.jira.jira-issue-nav-plugin";

    public PluginsControlExt(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    @Deprecated
    public PluginsControlExt enableIssueNavPlugin() {
        this.enablePlugin(ISSUE_NAV_PLUGIN_KEY);
        return this;
    }

    @Deprecated
    public PluginsControlExt disableIssueNavPlugin() {
        this.disablePlugin(ISSUE_NAV_PLUGIN_KEY);
        return this;
    }

    public List<PluginBean> listPlugins() {
        return ((PluginsResponse)this.upmResource().request().get(PluginsResponse.class)).plugins;
    }

    public void unistallPlugin(String pluginKey) {
        WebTarget pluginResource = this.createResourceForPath("plugins", "1.0").path("/" + pluginKey + "-key");
        pluginResource.request().delete();
    }

    public Optional<PluginBean> getPlugin(String pluginKey) {
        return this.listPlugins().stream().filter(plugin -> plugin.getKey().equals(pluginKey)).findFirst();
    }

    private WebTarget upmResource() {
        return this.createResourceForPath("plugins", "1.0").path("/");
    }

    public void uploadPlugin(URL pluginUrl) {
        this.upmResource().queryParam("token", new Object[]{this.getUpmToken()}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)this.getUploadPluginRequestBody(pluginUrl), (String)UPLOAD_PLUGIN_MIME_TYPE), String.class);
    }

    @Nonnull
    private String getUpmToken() {
        return (String)Objects.requireNonNull(((Response)this.upmResource().queryParam("os_authType", new Object[]{"basic"}).request(new String[]{GET_UPM_TOKEN_MIME_TYPE}).get(Response.class)).getStringHeaders().getFirst((Object)"upm-token"));
    }

    private String getUploadPluginRequestBody(URL pluginUrl) {
        try {
            JSONObject requestBody = new JSONObject();
            requestBody.put("pluginUri", pluginUrl);
            requestBody.put("pluginName", "ignored");
            return requestBody.toString();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    public static class PluginsResponse {
        @JsonProperty
        public List<PluginBean> plugins;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PluginBean {
        @JsonProperty
        public Boolean enabled;
        @JsonProperty
        public String name;
        @JsonProperty
        public String key;
        @JsonProperty
        public String version;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public String getName() {
            return this.name;
        }

        public String getKey() {
            return this.key;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

