/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.functest.framework.backdoor.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;

public class PrioritySchemesControl
extends BackdoorControl<PrioritySchemesControl> {
    private static final GenericType<List<PrioritySchemeData>> SCHEMES_LIST = new GenericType<List<PrioritySchemeData>>(){};

    public PrioritySchemesControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public List<PrioritySchemeData> getSchemes() {
        return (List)this.createResource().request().get(SCHEMES_LIST);
    }

    public PrioritySchemeData getSchemeByName(String name) {
        Preconditions.checkNotNull((Object)name);
        return this.getSchemes().stream().filter(scheme -> name.equals(((PrioritySchemeData)scheme).name)).findFirst().orElse(null);
    }

    public long createPriorityScheme(String name, String description, List<String> priorities) {
        WebTarget target = this.createResource().path("create").queryParam("name", new Object[]{name}).queryParam("description", new Object[]{description});
        for (String priority : priorities) {
            target = target.queryParam("priorities", new Object[]{priority});
        }
        return Long.valueOf(this.get(target));
    }

    public void updatePriorityScheme(long id, String name, String description, List<String> priorities) {
        WebTarget target = this.schemeTarget(id).path("update").queryParam("name", new Object[]{name}).queryParam("description", new Object[]{description});
        for (String priority : priorities) {
            target = target.queryParam("priorities", new Object[]{priority});
        }
        this.get(target);
    }

    public void deletePriorityScheme(long id) {
        this.get(this.schemeTarget(id).path("delete"));
    }

    public void setDefaultPriority(long id, String priorityId) {
        this.get(this.schemeTarget(id).path("setDefaultPriority").queryParam("priority", new Object[]{priorityId}));
    }

    public List<Long> getProjectWithScheme(long schemeId) {
        List integers = (List)this.schemeTarget(schemeId).path("projects").request().get(List.class);
        return integers.stream().map(Long::valueOf).collect(Collectors.toList());
    }

    public void assignProject(long schemeId, long projectId) {
        this.schemeTarget(schemeId).path("addProject").queryParam("projectId", new Object[]{String.valueOf(projectId)}).request().get(String.class);
    }

    public void unassignProject(long schemeId, long projectId) {
        this.schemeTarget(schemeId).path("deleteProject").queryParam("projectId", new Object[]{String.valueOf(projectId)}).request().get(String.class);
    }

    public void removePriorityFromAllSchemes(String priorityId) {
        this.createResource().path("removePriorityFromAllSchemes").queryParam("priorityId", new Object[]{priorityId}).request().get(String.class);
    }

    private WebTarget schemeTarget(long schemeId) {
        return this.createResource().path(String.valueOf(schemeId));
    }

    public long getOrCreateDefaultPriorityScheme() {
        WebTarget target = this.createResource().path("createOrGetDefaultScheme");
        return Long.valueOf(this.get(target));
    }

    @Override
    protected WebTarget createResource() {
        return super.createResource().path("priority/scheme");
    }

    public static class PrioritySchemeData {
        private Long id;
        private String name;
        private String description;
        private List<String> priorities;
        private String defaultPriority;

        public Long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public List<String> getPriorities() {
            return this.priorities;
        }

        public String getDefaultPriority() {
            return this.defaultPriority;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setPriorities(List<String> priorities) {
            this.priorities = priorities;
        }

        public void setDefaultPriority(String defaultPriority) {
            this.defaultPriority = defaultPriority;
        }
    }
}

