/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.functest.framework.backdoor.IndexingControl;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.rest.v2.issue.project.ProjectCategoryBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectInputBean;
import com.atlassian.jira.testkit.beans.WorkflowSchemeData;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.ProjectControl;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.testkit.client.restclient.ProjectClient;
import com.atlassian.jira.testkit.client.restclient.Version;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public class ProjectControlExt
extends ProjectControl {
    private final ProjectClient projectClient;
    private final IndexingControl indexingControl;

    public ProjectControlExt(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
        super((JIRAEnvironmentData)environmentData);
        this.projectClient = new ProjectClient((JIRAEnvironmentData)environmentData);
        this.indexingControl = new IndexingControl(environmentData);
    }

    public WorkflowSchemeData setWorkflowScheme(String projectKey, long id) {
        return (WorkflowSchemeData)this.createWorkflowSchemeResource(projectKey).request(new String[]{"application/json"}).post(Entity.json((Object)id), WorkflowSchemeData.class);
    }

    public void setDefaultWorkflowScheme(String projectKey) {
        this.createWorkflowSchemeResource(projectKey).request().delete();
    }

    private WebTarget createWorkflowSchemeResource(String projectKey) {
        return this.createResourceForPath("func-test").path("project").path(projectKey).path("workflowscheme");
    }

    public void addProjectKey(Long projectId, String previousProjectKey) {
        this.createProjectKeysResource(projectId).request().put(Entity.json((Object)previousProjectKey), String.class);
    }

    public String addProjectBasedOnExisting(String existingProjectKey, String newKey, String newName, String newLead) {
        ProjectInputBean inputBean = new ProjectInputBean.Builder().setKey(newKey).setName(newName).setLeadName(newLead).build();
        return (String)this.createProjectResource(existingProjectKey).request().post(Entity.json((Object)inputBean), String.class);
    }

    public void editProjectKey(Long projectId, String newProjectKey) {
        this.editProjectKeyNoWaitForReindex(projectId, newProjectKey);
        this.indexingControl.getProjectIndexingProgress(projectId).waitForCompletion();
    }

    public void editProjectKeyNoWaitForReindex(Long projectId, String newProjectKey) {
        this.createProjectKeyResource(projectId).request().put(Entity.json((Object)newProjectKey), String.class);
    }

    public Project getProject(String projectKey) {
        return this.projectClient.get(projectKey);
    }

    public List<Project> getProjects() {
        return this.projectClient.getProjects();
    }

    public List<Version> getVersionsForProject(String projectKey) {
        return this.projectClient.getVersions(projectKey);
    }

    public List<Component> getComponentsForProject(String projectKey) {
        return this.projectClient.getComponents(projectKey);
    }

    public Long getProjectId(String projectKey) {
        return (Long)this.createProjectResource(projectKey).path("id").request().get(Long.class);
    }

    public String getProjectCategoryName(String projectKey) {
        return (String)this.createProjectResource(projectKey).path("category").path("name").request().get(String.class);
    }

    public List<String> getProjectKeys(Long projectId) {
        return (List)this.createProjectKeysResource(projectId).request().get((GenericType)new GenericType<List<String>>(){});
    }

    public String getProjectName(Long projectId) {
        return (String)this.createProjectResourceWithId(projectId).path("name").request().get(String.class);
    }

    public ProjectCategoryBean addProjectCategory(String name) {
        return this.addProjectCategory(name, "");
    }

    public ProjectCategoryBean addProjectCategory(String name, String description) {
        ProjectCategoryBean category = new ProjectCategoryBean((ProjectCategory)new ProjectCategoryImpl(null, name, description), null);
        return (ProjectCategoryBean)this.createProjectCategoryResource().request().post(Entity.json((Object)category), ProjectCategoryBean.class);
    }

    public void deleteProjectCategory(String id) {
        this.createProjectCategoryResource().path(id).request().delete();
    }

    public Response archiveProject(String projectIdOrKey) {
        return this.projectClient.archive(projectIdOrKey);
    }

    public Response restoreProject(String projectIdOrKey) {
        return this.projectClient.restore(projectIdOrKey);
    }

    public void changeArchivedDate(String projectKey, long millis) {
        this.createProjectResource(projectKey).path("changeArchivedDate").queryParam("date", new Object[]{String.valueOf(millis)}).request().put(Entity.json((Object)""), String.class);
    }

    public ProjectControl loginAs(String username, String password) {
        this.projectClient.loginAs(username, password);
        super.loginAs(username, password);
        return this;
    }

    public ProjectControl anonymous() {
        this.projectClient.anonymous();
        super.anonymous();
        return this;
    }

    private WebTarget createProjectKeysResource(Long projectId) {
        return this.createProjectResourceWithId(projectId).path("keys");
    }

    private WebTarget createProjectKeyResource(Long projectId) {
        return this.createProjectResourceWithId(projectId).path("key");
    }

    private WebTarget createProjectResourceWithId(Long projectId) {
        return this.createProjectResource(Long.toString(projectId));
    }

    private WebTarget createProjectCategoryResource() {
        return this.createResourceForPath("api", "2").path("projectCategory");
    }

    private WebTarget createProjectResource(String projectIdOrKey) {
        return this.createResourceForPath("func-test").path("project").path(projectIdOrKey);
    }

    private class ProjectCategoryImpl
    implements ProjectCategory {
        private Long id;
        private String name;
        private String description;

        private ProjectCategoryImpl(Long id, String name, String description) {
            this.id = id;
            this.name = name;
            this.description = description;
        }

        public Long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

