/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.functest.framework.backdoor.BackdoorControl;
import com.atlassian.jira.functest.framework.backdoor.LicenseControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public class SchedulerControl
extends BackdoorControl<LicenseControl> {
    public static final GenericType<List<String>> LIST_OF_STRING = new GenericType<List<String>>(){};
    public static final GenericType<List<JobBean>> LIST_OF_JOB_BEAN = new GenericType<List<JobBean>>(){};

    SchedulerControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public List<String> getJobRunnerKeys() {
        return (List)this.scheduler().path("jobRunnerKeys").request().get(LIST_OF_STRING);
    }

    @Nullable
    public JobBean getJob(JobId jobId) {
        try {
            return (JobBean)this.scheduler().path("job").path(jobId.toString()).request().get(JobBean.class);
        }
        catch (WebApplicationException e) {
            return (JobBean)SchedulerControl.handleRestException(e);
        }
    }

    public List<JobBean> getJobsByJobRunnerKey(JobRunnerKey jobRunnerKey) {
        return (List)this.scheduler().path("jobs").path(jobRunnerKey.toString()).request().get(LIST_OF_JOB_BEAN);
    }

    public List<JobBean> getAllJobs() {
        return (List)this.scheduler().path("jobs").request().get(LIST_OF_JOB_BEAN);
    }

    @Nullable
    public JobRunBean getLastRun(JobId jobId) {
        try {
            return (JobRunBean)this.scheduler().path("job").path(jobId.toString()).path("last").request().get(JobRunBean.class);
        }
        catch (WebApplicationException e) {
            return (JobRunBean)SchedulerControl.handleRestException(e);
        }
    }

    @Nullable
    public JobRunBean getLastSuccessfulRun(JobId jobId) {
        try {
            return (JobRunBean)this.scheduler().path("job").path(jobId.toString()).path("lastSuccessful").request().get(JobRunBean.class);
        }
        catch (WebApplicationException e) {
            return (JobRunBean)SchedulerControl.handleRestException(e);
        }
    }

    public JobBean scheduleJob(RunMode mode) {
        return (JobBean)this.scheduler().path("job").request().post(Entity.json((Object)mode), JobBean.class);
    }

    private static <T> T handleRestException(WebApplicationException e) {
        if (e.getResponse().getStatusInfo() == Response.Status.NO_CONTENT) {
            return null;
        }
        throw e;
    }

    private WebTarget scheduler() {
        return this.createResource().path("scheduler");
    }

    @JsonAutoDetect
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JobBean {
        public String jobId;
        public String jobRunnerKey;
        public Long nextRunTime;
        public String runMode;
        public String scheduleType;
        public Long intervalInMillis;
        public Long firstRunTime;
        public String cronExpression;
        public String timeZoneId;
        public boolean runnable;
    }

    @JsonAutoDetect
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JobRunBean {
        public String message;
        public Date startTime;
        public long durationInMillis;
        public String runOutcome;

        public String toString() {
            return "JobRunBean{message='" + this.message + '\'' + ", startTime=" + this.startTime + ", durationInMillis=" + this.durationInMillis + ", runOutcome='" + this.runOutcome + '\'' + '}';
        }
    }
}

