/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.rest.v2.i18n.terminology.TerminologyRequestBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

public class TerminologyClient
extends RestApiClient<TerminologyClient> {
    private static final String TERMINOLOGY_ENTRIES_PATH = "/terminology/entries/";
    private static final String REST_API_VERSION = "2";

    public TerminologyClient(JIRAEnvironmentData environmentData) {
        super(environmentData, REST_API_VERSION);
    }

    public Response getTerminologyEntryForOriginalName(String originalName) {
        WebTarget target = this.createResource().path(TERMINOLOGY_ENTRIES_PATH + originalName);
        return (Response)target.request().get(Response.class);
    }

    public Response getAllTerminologyEntries() {
        WebTarget target = this.createResource().path(TERMINOLOGY_ENTRIES_PATH);
        return (Response)target.request().get(Response.class);
    }

    public Response setTerminologyEntry(TerminologyRequestBean bean) {
        return this.setTerminologyEntries((Collection<TerminologyRequestBean>)ImmutableList.of((Object)bean));
    }

    public Response setTerminologyEntries(Collection<TerminologyRequestBean> bean) {
        WebTarget resource = this.createResource().path(TERMINOLOGY_ENTRIES_PATH);
        return (Response)resource.request(new String[]{"application/json"}).post(Entity.json(bean), Response.class);
    }

    public Response setTerminologyEntryBulk(TerminologyRequestBean ... bean) {
        WebTarget resource = this.createResource().path(TERMINOLOGY_ENTRIES_PATH);
        return (Response)resource.request(new String[]{"application/json"}).post(Entity.json((Object)ImmutableList.copyOf((Object[])bean)), Response.class);
    }
}

