/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor;

import com.atlassian.jira.functest.framework.backdoor.BackdoorControl;
import com.atlassian.jira.rest.v2.user.anonymization.UserAnonymizationProgressBean;
import com.atlassian.jira.rest.v2.user.anonymization.UserAnonymizationRequestBean;
import com.atlassian.jira.rest.v2.user.anonymization.UserAnonymizationRerunRequestBean;
import com.atlassian.jira.rest.v2.user.anonymization.UserAnonymizationValidationBean;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.jayway.awaitility.Awaitility;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class UserAnonymizeControl
extends BackdoorControl<UserAnonymizeControl> {
    public UserAnonymizeControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public AnonymizePerformResult anonymize(String userKey) {
        return this.doAnonymize(AnonymizePerformResult.class, userKey, false, null, null, "admin");
    }

    public AnonymizePerformResult anonymize(String userKey, boolean rerunPluginPoints, String oldUserKey, String oldUserName, String newOwnerKey) {
        return this.doAnonymize(AnonymizePerformResult.class, userKey, rerunPluginPoints, oldUserKey, oldUserName, newOwnerKey);
    }

    public AnonymizePerformResultValidationError anonymizeWithValidationError(String userKey, boolean rerunPluginPoints, String oldUserKey, String oldUserName, String newOwnerKey) {
        Response response = this.doAnonymize(Response.class, userKey, rerunPluginPoints, oldUserKey, oldUserName, newOwnerKey);
        int status = response.getStatus();
        if (status != 400) {
            throw new RuntimeException("Wrong status, expected 400 was " + status);
        }
        return (AnonymizePerformResultValidationError)response.readEntity(AnonymizePerformResultValidationError.class);
    }

    public UserAnonymizationValidationBean validateUserAnonymization(String userKey, String expand) {
        return (UserAnonymizationValidationBean)this.createAsyncResource().queryParam("userKey", new Object[]{userKey}).queryParam("expand", new Object[]{expand != null ? expand : ""}).request(new String[]{"application/json"}).get(UserAnonymizationValidationBean.class);
    }

    public UserAnonymizationValidationBean validateUserAnonymizationRerun(String userKey, @Nullable String oldUserKey, @Nullable String oldUserName, String expand) {
        return (UserAnonymizationValidationBean)this.createAsyncResource().path("rerun").queryParam("userKey", new Object[]{userKey}).queryParam("oldUserKey", new Object[]{oldUserKey != null ? oldUserKey : ""}).queryParam("oldUserName", new Object[]{oldUserName != null ? oldUserName : ""}).queryParam("expand", new Object[]{expand != null ? expand : ""}).request(new String[]{"application/json"}).get(UserAnonymizationValidationBean.class);
    }

    public void scheduleUserAnonymization(String userKey, String newOwnerKey) {
        this.createAsyncResource().request(new String[]{"application/json"}).post(Entity.json((Object)new UserAnonymizationRequestBean(userKey, newOwnerKey)), String.class);
    }

    public void scheduleUserAnonymizationRerun(String userKey, String newOwnerKey, String oldUserKey, String oldUserName) {
        this.createAsyncResource().path("rerun").request(new String[]{"application/json"}).post(Entity.json((Object)new UserAnonymizationRerunRequestBean(userKey, newOwnerKey, oldUserKey, oldUserName)), String.class);
    }

    public UserAnonymizationProgressBean getProgress() {
        return this.getProgress(0L);
    }

    public UserAnonymizationProgressBean getProgress(long taskId) {
        return (UserAnonymizationProgressBean)this.createAsyncResource().path("progress").queryParam("taskId", new Object[]{String.valueOf(taskId)}).request(new String[]{"application/json"}).get(UserAnonymizationProgressBean.class);
    }

    @Nonnull
    public UserAnonymizationProgressBean fetchFinishedProgressResult() {
        return (UserAnonymizationProgressBean)Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(this::getProgress, Matchers.hasProperty((String)"finishTime", (Matcher)Matchers.notNullValue()));
    }

    private <T> T doAnonymize(Class<T> responseClass, String userKey, boolean rerunPluginPoints, String oldUserKey, String oldUserName, String newOwnerKey) {
        WebTarget target = this.createResource().path("userAnonymize").queryParam("userKey", new Object[]{userKey}).queryParam("rerunPluginPoints", new Object[]{Boolean.toString(rerunPluginPoints)});
        if (oldUserKey != null) {
            target = target.queryParam("oldUserKey", new Object[]{oldUserKey});
        }
        if (oldUserName != null) {
            target = target.queryParam("oldUserName", new Object[]{oldUserName});
        }
        if (newOwnerKey != null) {
            target = target.queryParam("newOwnerKey", new Object[]{newOwnerKey});
        }
        return (T)target.request().put(null, responseClass);
    }

    public String getExternalId(String userName) {
        WebTarget target = this.createResource().path("userAnonymize").path("externalId").queryParam("userName", new Object[]{userName});
        return (String)target.request().get(String.class);
    }

    private WebTarget createAsyncResource() {
        return this.resourceRoot(this.rootPath).path("rest").path("api").path("2").path("user").path("anonymization");
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AnonymizePerformResultValidationError {
        @JsonProperty
        private Collection<String> errors;
        @JsonProperty
        private Map<String, Collection<String>> affectedEntitiesReport;
        @JsonProperty
        private Map<String, Collection<String>> operationValidation;
        @JsonProperty
        private Map<String, Collection<String>> businessLogicValidationErrors;

        public Collection<String> getErrors() {
            return this.errors;
        }

        public Map<String, Collection<String>> getAffectedEntitiesReport() {
            return this.affectedEntitiesReport;
        }

        public Map<String, Collection<String>> getOperationValidation() {
            return this.operationValidation;
        }

        public Map<String, Collection<String>> getBusinessLogicValidationErrors() {
            return this.businessLogicValidationErrors;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AnonymizePerformResult {
        @JsonProperty
        private String userKey;
        @JsonProperty
        private String userKeyNew;
        @JsonProperty
        private String userNameNew;

        public String getUserKey() {
            return this.userKey;
        }

        public String getUserKeyNew() {
            return this.userKeyNew;
        }

        public String getUserNameNew() {
            return this.userNameNew;
        }
    }
}

