/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor.allowlist;

import com.atlassian.jira.functest.framework.backdoor.BackdoorControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.plugins.whitelist.ImmutableWhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.BooleanUtils;

public class AllowlistControl
extends BackdoorControl<AllowlistControl> {
    public AllowlistControl(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    @Override
    protected WebTarget createResource() {
        return this.resourceRoot(this.rootPath).path("rest").path("whitelist").path("latest/");
    }

    public List<WhitelistRule> getRules() {
        return ((WhitelistListResponseBean)this.createResource().request().get(WhitelistListResponseBean.class)).getRules().stream().map(WhitelistBean::asRule).collect(Collectors.toList());
    }

    public WhitelistRule createAllowlistRule(String expression, WhitelistType type) {
        WhitelistBean whitelistBean = new WhitelistBean(expression, WhitelistTypeMapper.asString(type), false, false);
        return ((WhitelistBean)this.createResource().request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)whitelistBean), WhitelistBean.class)).asRule();
    }

    public static class WhitelistTypeMapper {
        private static final Map<String, WhitelistType> whitelistTypeMap = Maps.uniqueIndex(Arrays.asList(WhitelistType.values()), WhitelistTypeMapper::asString);

        public static String asString(WhitelistType whitelistType) {
            Preconditions.checkNotNull((Object)whitelistType, (Object)"whitelistType");
            return "whitelist." + whitelistType.name().toLowerCase().replace('_', '.');
        }

        public static WhitelistType asType(String value) {
            Preconditions.checkNotNull((Object)value, (Object)"value");
            WhitelistType whitelistType = whitelistTypeMap.get(value);
            Preconditions.checkArgument((whitelistType != null ? 1 : 0) != 0, (Object)("Failed to find a matching whitelist type mapping for the given string '" + value + "'; known types are: " + whitelistTypeMap.keySet()));
            return whitelistType;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @Immutable
    public static final class WhitelistBean {
        private final Integer id = null;
        private final String expression;
        private final WhitelistType type;
        private final Boolean allowInbound;
        private final Boolean allowAnonymousUser;
        private final String iconUrl;

        @JsonCreator
        public WhitelistBean(@JsonProperty(value="expression") String expression, @JsonProperty(value="type") String type, @JsonProperty(value="allowInbound") Boolean allowInbound, @JsonProperty(value="allowAnonymousUser") Boolean allowAnonymousUser) {
            this.expression = expression;
            this.type = type != null ? WhitelistTypeMapper.asType(type) : null;
            this.iconUrl = null;
            this.allowInbound = allowInbound;
            this.allowAnonymousUser = allowAnonymousUser;
        }

        public WhitelistRule asRule() {
            return ImmutableWhitelistRule.builder().id(this.id).expression(this.expression).type(this.type).allowInbound(BooleanUtils.isTrue((Boolean)this.allowInbound)).authenticationRequired(BooleanUtils.isNotTrue((Boolean)this.allowAnonymousUser)).build();
        }

        @Nullable
        public Integer getId() {
            return this.id;
        }

        public String getExpression() {
            return this.expression;
        }

        @JsonIgnore
        public WhitelistType getType() {
            return this.type;
        }

        @JsonProperty(value="type")
        public String getTypeAsString() {
            return WhitelistTypeMapper.asString(this.type);
        }

        public String getIconUrl() {
            return this.iconUrl;
        }

        public Boolean isAllowInbound() {
            return this.allowInbound;
        }

        public Boolean isAllowAnonymousUser() {
            return this.allowAnonymousUser;
        }

        public boolean isAllowEdit() {
            return this.type != WhitelistType.APPLICATION_LINK;
        }

        public boolean isAllowDelete() {
            return this.type != WhitelistType.APPLICATION_LINK;
        }

        public String toString() {
            return "WhitelistBean{id=" + this.id + ", expression='" + this.expression + '\'' + ", type=" + this.type + '}';
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @Immutable
    private static class WhitelistListResponseBean {
        private final List<WhitelistBean> rules;
        private final int page;
        private final int totalPages;

        @JsonCreator
        public WhitelistListResponseBean(@JsonProperty(value="rules") List<WhitelistBean> rules, @JsonProperty(value="page") int page, @JsonProperty(value="totalPages") int totalPages) {
            this.rules = new ArrayList<WhitelistBean>(rules);
            this.page = page;
            this.totalPages = totalPages;
        }

        public List<WhitelistBean> getRules() {
            return this.rules;
        }

        public int getPage() {
            return this.page;
        }

        public int getTotalPages() {
            return this.totalPages;
        }
    }
}

