/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.backdoor.webhooks;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class WebHookRegistrationClient
extends RestApiClient<WebHookRegistrationClient> {
    public static final String ISSUES_SECTION_KEY = "issue-related-events-section";
    private final JIRAEnvironmentData environmentData;

    public WebHookRegistrationClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
        this.environmentData = environmentData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegistrationResponse register(Registration registration) {
        try (Response response = (Response)this.createResource().request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)registration), Response.class);){
            ((AbstractIntegerAssert)Assertions.assertThat((int)response.getStatus()).overridingErrorMessage("201 code expected, got " + response.getStatusInfo(), new Object[0])).isEqualTo(201);
            RegistrationResponse entity = (RegistrationResponse)response.readEntity(RegistrationResponse.class);
            Assertions.assertThat((String)response.getLocation().toString()).isEqualTo(entity.self);
            RegistrationResponse registrationResponse = entity;
            return registrationResponse;
        }
    }

    public RegistrationResponse getWebHook(String id) {
        return (RegistrationResponse)this.createResource().path(id).request().get(RegistrationResponse.class);
    }

    public void delete(String id) {
        this.createResource().path(id).request().delete(String.class);
    }

    public List<RegistrationResponse> getAllWebHooks() {
        return (List)this.createResource().request().get((GenericType)new GenericType<List<RegistrationResponse>>(){});
    }

    public void updateStatus(String id, Registration registration) {
        this.createResource().path(id).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)registration), String.class);
    }

    public RegistrationResponse update(String id, Registration registration) {
        return (RegistrationResponse)this.createResource().path(id).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)registration), RegistrationResponse.class);
    }

    protected WebTarget createResource() {
        return this.resourceRoot(this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("webhooks").path("1.0").path("webhook");
    }

    public WebTarget createResource(String rawUrl) {
        return this.resourceRoot(rawUrl);
    }

    public void enable(String id) {
        this.switchEnablement(id, true);
    }

    public void disable(String id) {
        this.switchEnablement(id, false);
    }

    private void switchEnablement(String id, boolean state) {
        Registration registration = new Registration();
        registration.enabled = state;
        this.updateStatus(id, registration);
    }

    @XmlRootElement
    public static class RegistrationResponse
    extends Registration {
        public String self;
        public String lastUpdatedUser;
        public String lastUpdatedDisplayName;
        public long lastUpdated;
        public String lastUpdatedShort;
        public boolean enabled = true;

        public RegistrationResponse() {
        }

        public RegistrationResponse(Registration from) throws InvocationTargetException, IllegalAccessException {
            this.name = from.name;
            this.url = from.url;
            this.events = from.events;
            this.filters = from.filters;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (Collection)ImmutableList.of((Object)"lastUpdated", (Object)"lastUpdatedShort")) && Math.abs(this.lastUpdated - ((RegistrationResponse)obj).lastUpdated) < 5000L;
        }

        @Override
        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
        }
    }

    @XmlRootElement
    public static class Registration {
        public String name;
        public String url;
        @JsonIgnore
        public String path;
        public String[] events;
        public boolean excludeBody;
        public Map<String, String> filters;
        public boolean enabled = true;

        public Registration() {
            this.enabled = true;
        }

        public Registration(Registration registration) {
            this.name = registration.name;
            this.url = registration.url;
            this.path = registration.path;
            this.events = registration.events;
            this.excludeBody = registration.excludeBody;
            this.filters = registration.filters;
            this.enabled = registration.enabled;
        }

        @JsonIgnore
        public void setFilterForIssueSection(String filter) {
            if (this.filters == null) {
                this.filters = Maps.newHashMap();
            }
            this.filters.put(WebHookRegistrationClient.ISSUES_SECTION_KEY, filter);
        }

        @JsonIgnore
        public String getFilterForIssueSection() {
            return Strings.nullToEmpty((String)((String)((Map)MoreObjects.firstNonNull(this.filters, Collections.emptyMap())).get(WebHookRegistrationClient.ISSUES_SECTION_KEY)));
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
        }
    }
}

