/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.dashboard;

import com.atlassian.jira.functest.framework.sharing.SharedEntityInfo;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermission;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class DashboardPageInfo
extends SharedEntityInfo {
    private List<Operation> operations = null;

    public DashboardPageInfo(long id, String name, String description, boolean favourite, Set<TestSharingPermission> permissions, String owner, int favCount, List<Operation> operations) {
        this(new Long(id), name, description, favourite, permissions, owner, new Integer(favCount), operations);
    }

    public DashboardPageInfo(Long id, String name, String description, boolean favourite, Set<TestSharingPermission> sharingPermissions, String owner, Integer favCount, List<Operation> operations) {
        super(id, name, description, favourite, sharingPermissions, owner, favCount);
        this.operations = operations;
    }

    public DashboardPageInfo(Long id, String name, String description, boolean favourite, Set<TestSharingPermission> sharingPermissions) {
        super(id, name, description, favourite, sharingPermissions, null, null);
        this.operations = null;
    }

    public DashboardPageInfo(DashboardPageInfo dashboardInfo) {
        super(dashboardInfo);
        this.operations = dashboardInfo.getOperations();
    }

    public List<Operation> getOperations() {
        return this.operations;
    }

    public DashboardPageInfo setOperations(List<Operation> operations) {
        this.operations = operations;
        return this;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public DashboardPageInfo copy() {
        return new DashboardPageInfo(this);
    }

    public static class Operation {
        public static Operation EDIT = new Operation("Edit", "EditPortalPage!default.jspa?pageId=");
        public static Operation DELETE = new Operation("Delete", "DeletePortalPage!default.jspa?pageId=");
        public static Operation COPY = new Operation("Copy", "AddPortalPage!default.jspa?clonePageId=");
        public static final List<Operation> NONE = Collections.emptyList();
        public static final List<Operation> ALL = Arrays.asList(EDIT, DELETE, COPY);
        public static final List<Operation> COPY_ONLY = Collections.singletonList(COPY);
        private final String linkName;
        private final String linkPrefix;

        public Operation(String linkName, String linkPrefix) {
            this.linkName = linkName;
            this.linkPrefix = linkPrefix;
        }

        public String getUrl(long id) {
            return this.linkPrefix + id;
        }

        public String getLinkName() {
            return this.linkName;
        }

        public String toString() {
            return this.linkName;
        }
    }
}

