/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.jsoup;

import com.atlassian.jira.functest.framework.jsoup.JSoupNode;
import java.util.Collections;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public class JSoupW3CEmitter {
    private final Document document;

    public static JSoupW3CEmitter parse(String htmlInput) {
        Document document = Jsoup.parse((String)htmlInput);
        return new JSoupW3CEmitter(document);
    }

    public JSoupW3CEmitter() {
        this.document = null;
    }

    public JSoupW3CEmitter(Document document) {
        this.document = document;
    }

    public NodeList select(String cssSelector, org.w3c.dom.Node node) {
        if (node instanceof EmittedElement) {
            EmittedElement emittedElement = (EmittedElement)node;
            return this.wrapNodeList((List<? extends Node>)emittedElement.element.select(cssSelector));
        }
        if (node instanceof EmittedDocument) {
            EmittedDocument emittedDocument = (EmittedDocument)node;
            return this.wrapNodeList((List<? extends Node>)emittedDocument.document.select(cssSelector));
        }
        throw new IllegalArgumentException("You must provide a Document or Element node");
    }

    public org.w3c.dom.Document getDocument() {
        return this.wrapDocument(this.document);
    }

    private org.w3c.dom.Document wrapDocument(Document document) {
        return (org.w3c.dom.Document)this.wrapNode((Node)document);
    }

    private Element wrapElement(org.jsoup.nodes.Element element) {
        return (Element)this.wrapNode((Node)element);
    }

    private org.w3c.dom.Node wrapNode(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof Document) {
            return new EmittedDocument(node);
        }
        if (node instanceof org.jsoup.nodes.Element) {
            return new EmittedElement(node);
        }
        if (node instanceof TextNode) {
            return new EmittedText(node);
        }
        if (node instanceof org.jsoup.nodes.Comment) {
            return new EmittedComment(node);
        }
        if (node instanceof DataNode) {
            return new EmittedCDATASection(node);
        }
        return new EmittedNode(node);
    }

    Attr wrapAttr(org.jsoup.nodes.Element element, int index, Attribute attribute) {
        return new EmittedAttr(element, index, attribute);
    }

    private static void unsupported() {
        throw new DOMException(666, "Unimplemented Operation");
    }

    private NodeList wrapNodeList(List<? extends Node> nodes) {
        EmittedNodeList nodeList = nodes != null ? new EmittedNodeList(nodes) : new EmittedNodeList(Collections.emptyList());
        return nodeList;
    }

    private FoundAttr findAttribute(org.jsoup.nodes.Element element, String name) {
        int index = 0;
        for (Attribute attribute : element.attributes()) {
            if (name.equalsIgnoreCase(attribute.getKey())) {
                return new FoundAttr(index, attribute);
            }
            ++index;
        }
        return null;
    }

    class EmittedNode
    implements JSoupNode {
        final Node node;

        EmittedNode(Node node) {
            this.node = node;
        }

        public String toString() {
            return this.getClass().getSimpleName() + '@' + System.identityHashCode(this) + ' ' + this.getNodeName() + " : " + this.node;
        }

        @Override
        public String getNodeName() {
            return this.node.nodeName();
        }

        @Override
        public String getNodeValue() throws DOMException {
            if (this.node instanceof org.jsoup.nodes.Element) {
                return ((org.jsoup.nodes.Element)this.node).text();
            }
            if (this.node instanceof TextNode) {
                return ((TextNode)this.node).getWholeText();
            }
            if (this.node instanceof DataNode) {
                return ((DataNode)this.node).getWholeData();
            }
            return "";
        }

        @Override
        public void setNodeValue(String nodeValue) throws DOMException {
            JSoupW3CEmitter.unsupported();
        }

        @Override
        public short getNodeType() {
            if (this.node instanceof Document) {
                return 9;
            }
            if (this.node instanceof org.jsoup.nodes.Element) {
                return 1;
            }
            if (this.node instanceof org.jsoup.nodes.Comment) {
                return 8;
            }
            if (this.node instanceof TextNode) {
                return 3;
            }
            if (this.node instanceof DataNode) {
                return 4;
            }
            return 3;
        }

        @Override
        public org.w3c.dom.Node getParentNode() {
            return JSoupW3CEmitter.this.wrapNode(this.node.parent());
        }

        @Override
        public NodeList getChildNodes() {
            return JSoupW3CEmitter.this.wrapNodeList(this.node.childNodes());
        }

        @Override
        public org.w3c.dom.Node getFirstChild() {
            List children = this.node.childNodes();
            if (children.size() == 0) {
                return null;
            }
            return JSoupW3CEmitter.this.wrapNode((Node)children.get(0));
        }

        @Override
        public org.w3c.dom.Node getLastChild() {
            List children = this.node.childNodes();
            if (children.size() == 0) {
                return null;
            }
            return JSoupW3CEmitter.this.wrapNode((Node)children.get(children.size() - 1));
        }

        @Override
        public org.w3c.dom.Node getPreviousSibling() {
            return JSoupW3CEmitter.this.wrapNode(this.node.previousSibling());
        }

        @Override
        public org.w3c.dom.Node getNextSibling() {
            return JSoupW3CEmitter.this.wrapNode(this.node.nextSibling());
        }

        @Override
        public NamedNodeMap getAttributes() {
            if (this.node instanceof org.jsoup.nodes.Element) {
                return new EmittedNameNodeMap((org.jsoup.nodes.Element)this.node);
            }
            return null;
        }

        @Override
        public org.w3c.dom.Document getOwnerDocument() {
            return null;
        }

        @Override
        public org.w3c.dom.Node insertBefore(org.w3c.dom.Node newChild, org.w3c.dom.Node refChild) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public org.w3c.dom.Node replaceChild(org.w3c.dom.Node newChild, org.w3c.dom.Node oldChild) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public org.w3c.dom.Node removeChild(org.w3c.dom.Node oldChild) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public org.w3c.dom.Node appendChild(org.w3c.dom.Node newChild) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public boolean hasChildNodes() {
            return this.node instanceof org.jsoup.nodes.Element && this.node.childNodes().size() > 0;
        }

        @Override
        public org.w3c.dom.Node cloneNode(boolean deep) {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public void normalize() {
        }

        @Override
        public boolean isSupported(String feature, String version) {
            JSoupW3CEmitter.unsupported();
            return false;
        }

        @Override
        public String getNamespaceURI() {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public String getPrefix() {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public void setPrefix(String prefix) throws DOMException {
            JSoupW3CEmitter.unsupported();
        }

        @Override
        public String getLocalName() {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public boolean hasAttributes() {
            return this.node instanceof org.jsoup.nodes.Element && this.node.attributes().size() > 0;
        }

        @Override
        public String getBaseURI() {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public short compareDocumentPosition(org.w3c.dom.Node other) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return 0;
        }

        @Override
        public String getTextContent() throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public void setTextContent(String textContent) throws DOMException {
            JSoupW3CEmitter.unsupported();
        }

        @Override
        public boolean isSameNode(org.w3c.dom.Node other) {
            JSoupW3CEmitter.unsupported();
            return false;
        }

        @Override
        public String lookupPrefix(String namespaceURI) {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public boolean isDefaultNamespace(String namespaceURI) {
            JSoupW3CEmitter.unsupported();
            return false;
        }

        @Override
        public String lookupNamespaceURI(String prefix) {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public boolean isEqualNode(org.w3c.dom.Node arg) {
            JSoupW3CEmitter.unsupported();
            return false;
        }

        @Override
        public Object getFeature(String feature, String version) {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public Object setUserData(String key, Object data, UserDataHandler handler) {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public Object getUserData(String key) {
            JSoupW3CEmitter.unsupported();
            return null;
        }
    }

    class EmittedAttr
    implements Attr,
    JSoupNode {
        private final org.jsoup.nodes.Element parent;
        private final int index;
        private final Attribute attribute;

        EmittedAttr(org.jsoup.nodes.Element parent, int index, Attribute attribute) {
            this.parent = parent;
            this.index = index;
            this.attribute = attribute;
        }

        @Override
        public String getName() {
            return this.attribute.getKey();
        }

        @Override
        public boolean getSpecified() {
            return true;
        }

        @Override
        public String getValue() {
            return this.attribute.getValue();
        }

        @Override
        public void setValue(String value) throws DOMException {
            JSoupW3CEmitter.unsupported();
        }

        @Override
        public Element getOwnerElement() {
            return (Element)JSoupW3CEmitter.this.wrapNode((Node)this.parent);
        }

        @Override
        public TypeInfo getSchemaTypeInfo() {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public boolean isId() {
            return "id".equalsIgnoreCase(this.attribute.getKey());
        }

        @Override
        public String getNodeName() {
            return this.getName();
        }

        @Override
        public String getNodeValue() throws DOMException {
            return this.getValue();
        }

        @Override
        public void setNodeValue(String nodeValue) throws DOMException {
            JSoupW3CEmitter.unsupported();
        }

        @Override
        public short getNodeType() {
            return 2;
        }

        @Override
        public org.w3c.dom.Node getParentNode() {
            return JSoupW3CEmitter.this.wrapNode((Node)this.parent);
        }

        @Override
        public NodeList getChildNodes() {
            return JSoupW3CEmitter.this.wrapNodeList(Collections.emptyList());
        }

        @Override
        public org.w3c.dom.Node getFirstChild() {
            return null;
        }

        @Override
        public org.w3c.dom.Node getLastChild() {
            return null;
        }

        @Override
        public org.w3c.dom.Node getPreviousSibling() {
            if (this.index > 0) {
                Attribute attribute = (Attribute)this.parent.attributes().asList().get(this.index - 1);
                return new EmittedAttr(this.parent, this.index - 1, attribute);
            }
            return null;
        }

        @Override
        public org.w3c.dom.Node getNextSibling() {
            List attributeList = this.parent.attributes().asList();
            if (this.index < attributeList.size() - 1) {
                Attribute attribute = (Attribute)attributeList.get(this.index + 1);
                return new EmittedAttr(this.parent, this.index + 1, attribute);
            }
            return null;
        }

        @Override
        public NamedNodeMap getAttributes() {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public org.w3c.dom.Document getOwnerDocument() {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public org.w3c.dom.Node insertBefore(org.w3c.dom.Node newChild, org.w3c.dom.Node refChild) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public org.w3c.dom.Node replaceChild(org.w3c.dom.Node newChild, org.w3c.dom.Node oldChild) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public org.w3c.dom.Node removeChild(org.w3c.dom.Node oldChild) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public org.w3c.dom.Node appendChild(org.w3c.dom.Node newChild) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public boolean hasChildNodes() {
            return false;
        }

        @Override
        public org.w3c.dom.Node cloneNode(boolean deep) {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public void normalize() {
        }

        @Override
        public boolean isSupported(String feature, String version) {
            return false;
        }

        @Override
        public String getNamespaceURI() {
            return null;
        }

        @Override
        public String getPrefix() {
            return null;
        }

        @Override
        public void setPrefix(String prefix) throws DOMException {
            JSoupW3CEmitter.unsupported();
        }

        @Override
        public String getLocalName() {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public boolean hasAttributes() {
            return false;
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public short compareDocumentPosition(org.w3c.dom.Node other) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return 0;
        }

        @Override
        public String getTextContent() throws DOMException {
            return this.getValue();
        }

        @Override
        public void setTextContent(String textContent) throws DOMException {
            JSoupW3CEmitter.unsupported();
        }

        @Override
        public boolean isSameNode(org.w3c.dom.Node other) {
            JSoupW3CEmitter.unsupported();
            return false;
        }

        @Override
        public String lookupPrefix(String namespaceURI) {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public boolean isDefaultNamespace(String namespaceURI) {
            JSoupW3CEmitter.unsupported();
            return false;
        }

        @Override
        public String lookupNamespaceURI(String prefix) {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public boolean isEqualNode(org.w3c.dom.Node arg) {
            JSoupW3CEmitter.unsupported();
            return false;
        }

        @Override
        public Object getFeature(String feature, String version) {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public Object setUserData(String key, Object data, UserDataHandler handler) {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public Object getUserData(String key) {
            JSoupW3CEmitter.unsupported();
            return null;
        }
    }

    class EmittedComment
    extends EmittedNode
    implements Comment {
        EmittedComment(Node node) {
            super(node);
        }

        @Override
        public String getData() throws DOMException {
            return this.getNodeValue();
        }

        @Override
        public void setData(String data) throws DOMException {
            JSoupW3CEmitter.unsupported();
        }

        @Override
        public int getLength() {
            String s = this.getNodeValue();
            return s == null ? 0 : s.length();
        }

        @Override
        public String substringData(int offset, int count) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public void appendData(String arg) throws DOMException {
            JSoupW3CEmitter.unsupported();
        }

        @Override
        public void insertData(int offset, String arg) throws DOMException {
            JSoupW3CEmitter.unsupported();
        }

        @Override
        public void deleteData(int offset, int count) throws DOMException {
            JSoupW3CEmitter.unsupported();
        }

        @Override
        public void replaceData(int offset, int count, String arg) throws DOMException {
            JSoupW3CEmitter.unsupported();
        }
    }

    class EmittedCharacterData
    extends EmittedNode
    implements CharacterData {
        EmittedCharacterData(Node node) {
            super(node);
        }

        @Override
        public String getData() throws DOMException {
            return this.getNodeValue();
        }

        @Override
        public void setData(String data) throws DOMException {
            JSoupW3CEmitter.unsupported();
        }

        @Override
        public int getLength() {
            String s = this.getNodeValue();
            return s == null ? 0 : s.length();
        }

        @Override
        public String substringData(int offset, int count) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public void appendData(String arg) throws DOMException {
            JSoupW3CEmitter.unsupported();
        }

        @Override
        public void insertData(int offset, String arg) throws DOMException {
            JSoupW3CEmitter.unsupported();
        }

        @Override
        public void deleteData(int offset, int count) throws DOMException {
            JSoupW3CEmitter.unsupported();
        }

        @Override
        public void replaceData(int offset, int count, String arg) throws DOMException {
            JSoupW3CEmitter.unsupported();
        }
    }

    class EmittedText
    extends EmittedCharacterData
    implements Text {
        EmittedText(Node node) {
            super(node);
        }

        @Override
        public Text splitText(int offset) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public boolean isElementContentWhitespace() {
            String s = this.getWholeText();
            if (s != null && s.length() > 0) {
                for (char c : s.toCharArray()) {
                    if (Character.isWhitespace(c)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public String getWholeText() {
            return this.getNodeValue();
        }

        @Override
        public Text replaceWholeText(String content) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }
    }

    class EmittedCDATASection
    extends EmittedText
    implements CDATASection {
        EmittedCDATASection(Node node) {
            super(node);
        }
    }

    class EmittedElement
    extends EmittedNode
    implements Element {
        final org.jsoup.nodes.Element element;

        EmittedElement(Node node) {
            super(node);
            this.element = (org.jsoup.nodes.Element)node;
        }

        @Override
        public String getTagName() {
            return this.node.nodeName();
        }

        @Override
        public String getAttribute(String name) {
            return this.element.attr(name);
        }

        @Override
        public void setAttribute(String name, String value) throws DOMException {
            JSoupW3CEmitter.unsupported();
        }

        @Override
        public void removeAttribute(String name) throws DOMException {
            JSoupW3CEmitter.unsupported();
        }

        @Override
        public Attr getAttributeNode(String name) {
            FoundAttr foundAttr = JSoupW3CEmitter.this.findAttribute(this.element, name);
            if (foundAttr != null) {
                return JSoupW3CEmitter.this.wrapAttr(this.element, foundAttr.index, foundAttr.attribute);
            }
            return null;
        }

        @Override
        public Attr setAttributeNode(Attr newAttr) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public NodeList getElementsByTagName(String name) {
            Elements elements = this.element.getElementsByTag(name);
            return JSoupW3CEmitter.this.wrapNodeList((List)elements);
        }

        @Override
        public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
            JSoupW3CEmitter.unsupported();
        }

        @Override
        public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
            JSoupW3CEmitter.unsupported();
        }

        @Override
        public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public NodeList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public boolean hasAttribute(String name) {
            return this.element.attr(name) != null;
        }

        @Override
        public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return false;
        }

        @Override
        public TypeInfo getSchemaTypeInfo() {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public void setIdAttribute(String name, boolean isId) throws DOMException {
            JSoupW3CEmitter.unsupported();
        }

        @Override
        public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
            JSoupW3CEmitter.unsupported();
        }

        @Override
        public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
            JSoupW3CEmitter.unsupported();
        }
    }

    class EmittedDocument
    extends EmittedNode
    implements org.w3c.dom.Document {
        final Document document;

        EmittedDocument(Node node) {
            super(node);
            this.document = (Document)node;
        }

        @Override
        public NodeList getElementsByTagName(String tagName) {
            return JSoupW3CEmitter.this.wrapNodeList((List)this.document.getElementsByTag(tagName));
        }

        @Override
        public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public DocumentType getDoctype() {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public DOMImplementation getImplementation() {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public Element getDocumentElement() {
            List children = this.document.childNodes();
            if (children.size() > 0) {
                return (Element)JSoupW3CEmitter.this.wrapNode((Node)children.get(0));
            }
            return null;
        }

        @Override
        public Element createElement(String tagName) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public DocumentFragment createDocumentFragment() {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public Text createTextNode(String data) {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public Comment createComment(String data) {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public CDATASection createCDATASection(String data) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public Attr createAttribute(String name) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public EntityReference createEntityReference(String name) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public org.w3c.dom.Node importNode(org.w3c.dom.Node importedNode, boolean deep) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public Element getElementById(String elementId) {
            return JSoupW3CEmitter.this.wrapElement(this.document.getElementById(elementId));
        }

        @Override
        public String getInputEncoding() {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public String getXmlEncoding() {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public boolean getXmlStandalone() {
            JSoupW3CEmitter.unsupported();
            return false;
        }

        @Override
        public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
            JSoupW3CEmitter.unsupported();
        }

        @Override
        public String getXmlVersion() {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public void setXmlVersion(String xmlVersion) throws DOMException {
            JSoupW3CEmitter.unsupported();
        }

        @Override
        public boolean getStrictErrorChecking() {
            JSoupW3CEmitter.unsupported();
            return false;
        }

        @Override
        public void setStrictErrorChecking(boolean strictErrorChecking) {
            JSoupW3CEmitter.unsupported();
        }

        @Override
        public String getDocumentURI() {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public void setDocumentURI(String documentURI) {
            JSoupW3CEmitter.unsupported();
        }

        @Override
        public org.w3c.dom.Node adoptNode(org.w3c.dom.Node source) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public DOMConfiguration getDomConfig() {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public void normalizeDocument() {
            JSoupW3CEmitter.unsupported();
        }

        @Override
        public org.w3c.dom.Node renameNode(org.w3c.dom.Node n, String namespaceURI, String qualifiedName) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }
    }

    class EmittedNameNodeMap
    implements NamedNodeMap {
        private final org.jsoup.nodes.Element element;

        EmittedNameNodeMap(org.jsoup.nodes.Element element) {
            this.element = element;
        }

        @Override
        public org.w3c.dom.Node getNamedItem(String name) {
            FoundAttr foundAttr = JSoupW3CEmitter.this.findAttribute(this.element, name);
            if (foundAttr != null) {
                return JSoupW3CEmitter.this.wrapAttr(this.element, foundAttr.index, foundAttr.attribute);
            }
            return null;
        }

        @Override
        public org.w3c.dom.Node setNamedItem(org.w3c.dom.Node arg) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public org.w3c.dom.Node removeNamedItem(String name) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public org.w3c.dom.Node item(int index) {
            List attributeList = this.element.attributes().asList();
            Attribute foundAttr = (Attribute)attributeList.get(index);
            if (foundAttr != null) {
                return new EmittedAttr(this.element, index, foundAttr);
            }
            return null;
        }

        @Override
        public int getLength() {
            return this.element.attributes().size();
        }

        @Override
        public org.w3c.dom.Node getNamedItemNS(String namespaceURI, String localName) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public org.w3c.dom.Node setNamedItemNS(org.w3c.dom.Node arg) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }

        @Override
        public org.w3c.dom.Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
            JSoupW3CEmitter.unsupported();
            return null;
        }
    }

    private class FoundAttr {
        int index;
        Attribute attribute;

        FoundAttr(int index, Attribute attribute) {
            this.index = index;
            this.attribute = attribute;
        }
    }

    class EmittedNodeList
    implements NodeList {
        private final List<? extends Node> nodes;

        EmittedNodeList(List<? extends Node> nodes) {
            this.nodes = nodes;
        }

        @Override
        public org.w3c.dom.Node item(int index) {
            return JSoupW3CEmitter.this.wrapNode(this.nodes.get(index));
        }

        @Override
        public int getLength() {
            return this.nodes.size();
        }
    }
}

