/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.labels;

import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.util.dom.DomKit;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.jwebunit.WebTester;
import org.w3c.dom.Node;

public class Labels {
    private final boolean editable;
    private final boolean linked;
    private final boolean lozenges;
    private final Set<String> labelValues;

    public Labels(boolean editable, boolean linked, boolean lozenges, String ... labelValues) {
        this(editable, linked, lozenges, new HashSet<String>(Arrays.asList(labelValues)));
    }

    public Labels(boolean editable, boolean linked, boolean lozenges, Set<String> labelValues) {
        this.editable = editable;
        this.linked = linked;
        this.lozenges = lozenges;
        this.labelValues = labelValues;
    }

    public static Labels parseLabels(WebTester tester, String issueId, String fieldId) {
        Set<String> labelValues = Labels.parseLabelValues(tester, issueId, fieldId);
        if (labelValues == null) {
            return null;
        }
        boolean editable = Labels.parseIsEditable(tester, issueId, fieldId);
        boolean linked = Labels.parseIsLinked(tester, issueId, fieldId);
        boolean lozenges = Labels.parseIsLozenges(tester, issueId, fieldId);
        return new Labels(editable, linked, lozenges, labelValues);
    }

    private static Set<String> parseLabelValues(WebTester tester, String issueId, String fieldId) {
        IdLocator idLocator = new IdLocator(tester, fieldId + "-" + issueId + "-value");
        if (!idLocator.hasNodes()) {
            return null;
        }
        if (idLocator.getNodes().length > 1) {
            throw new RuntimeException("Id should only ever refer to one set of labels.");
        }
        Node containerNode = idLocator.getNode();
        Set<String> labels = Collections.emptySet();
        if (containerNode.getNodeName().equalsIgnoreCase("TD")) {
            String labelValues = idLocator.getText().trim();
            String[] strings = labelValues.split(",\\s");
            if (!(strings.length <= 0 || strings.length == 1 && strings[0].equalsIgnoreCase("none"))) {
                labels = new HashSet<String>(Arrays.asList(strings));
            }
        } else if (containerNode.getNodeName().equalsIgnoreCase("UL")) {
            XPathLocator locator = new XPathLocator(tester, "//ul[@id='" + fieldId + "-" + issueId + "-value']//a[contains(@class, 'lozenge')]");
            labels = new HashSet<String>();
            for (Node node : locator.getNodes()) {
                labels.add(DomKit.getCollapsedText(node).trim());
            }
        } else if (containerNode.getNodeName().equalsIgnoreCase("span")) {
            // empty if block
        }
        return labels;
    }

    private static boolean parseIsEditable(WebTester tester, String issueId, String fieldId) {
        IdLocator locator = new IdLocator(tester, "edit-labels-" + issueId + "-" + fieldId);
        return locator.getNodes().length > 0;
    }

    private static boolean parseIsLozenges(WebTester tester, String issueId, String fieldId) {
        XPathLocator pathLocator = new XPathLocator(tester, "//*[@id='" + fieldId + "-" + issueId + "-value']//a[contains(@class, 'lozenge')]");
        return pathLocator.exists();
    }

    private static boolean parseIsLinked(WebTester tester, String issueId, String fieldId) {
        XPathLocator pathLocator = new XPathLocator(tester, "//*[@id='" + fieldId + "-" + issueId + "-value']//a[contains(@class, 'nolink')]");
        if (pathLocator.exists()) {
            return false;
        }
        pathLocator = new XPathLocator(tester, "//*[@id='" + fieldId + "-" + issueId + "-value']//a[contains(@class, 'lozenge')]");
        if (pathLocator.exists()) {
            return true;
        }
        pathLocator = new XPathLocator(tester, "//*[@id='" + fieldId + "-" + issueId + "-value']//a");
        return pathLocator.exists();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isLinked() {
        return this.linked;
    }

    public boolean isLozenges() {
        return this.lozenges;
    }

    public Set<String> getLabelValues() {
        return this.labelValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Labels labels = (Labels)o;
        if (this.editable != labels.editable) {
            return false;
        }
        if (this.linked != labels.linked) {
            return false;
        }
        if (this.lozenges != labels.lozenges) {
            return false;
        }
        return !(this.labelValues != null ? !this.labelValues.equals(labels.labelValues) : labels.labelValues != null);
    }

    public int hashCode() {
        int result = this.editable ? 1 : 0;
        result = 31 * result + (this.linked ? 1 : 0);
        result = 31 * result + (this.lozenges ? 1 : 0);
        result = 31 * result + (this.labelValues != null ? this.labelValues.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Labels{editable=" + this.editable + ", linked=" + this.linked + ", lozenges=" + this.lozenges + ", labelValues=" + this.labelValues + '}';
    }
}

