/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.matchers;

import com.atlassian.jira.util.dbc.Assertions;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class DocumentMatchers {
    private DocumentMatchers() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Don't clone me");
    }

    public static Matcher<Element> elementWithName(final String name) {
        return new TypeSafeDiagnosingMatcher<Element>(){

            protected boolean matchesSafely(Element item, Description mismatchDescription) {
                if (!name.equals(item.getName())) {
                    mismatchDescription.appendText("Expected ").appendValue((Object)name).appendText(" but was ").appendValue((Object)item.getName());
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("An element with name ").appendValue((Object)name);
            }
        };
    }

    public static Matcher<Comment> commentWithText(final String text) {
        Assertions.notNull(text);
        return new TypeSafeDiagnosingMatcher<Comment>(){

            protected boolean matchesSafely(Comment comment, Description description) {
                boolean result = text.equals(comment.getText());
                if (!result) {
                    description.appendText("Expected ").appendValue((Object)text).appendText(" but was ").appendValue((Object)comment.getText());
                }
                return result;
            }

            public void describeTo(Description description) {
                description.appendText("A Comment with text ").appendText(text);
            }
        };
    }

    public static Matcher<Document> documentWithNodes(final Class<? extends Node> ... nodeTypes) {
        return new TypeSafeDiagnosingMatcher<Document>(){

            protected boolean matchesSafely(Document item, Description mismatchDescription) {
                if (item.content().size() < nodeTypes.length) {
                    mismatchDescription.appendText("Expected at least ").appendValue((Object)nodeTypes.length).appendText(" nodes, but the document has only ").appendValue((Object)item.content().size());
                }
                for (int i = 0; i < nodeTypes.length; ++i) {
                    if (nodeTypes[i].isInstance(item.content().get(i))) continue;
                    mismatchDescription.appendText("Expected type ").appendValue((Object)nodeTypes[i]).appendText(" at position").appendValue((Object)i).appendText(" but was ").appendValue(((Node)item.content().get(i)).getClass());
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("A document with the following nodes (in order): ").appendValueList("[", ",", "]", (Object[])nodeTypes);
            }
        };
    }

    public static <N extends Node> Matcher<Document> hasNodeAt(final int position, final Class<N> nodeType, final Matcher<N> nodeMatcher) {
        return new TypeSafeDiagnosingMatcher<Document>(){

            protected boolean matchesSafely(Document item, Description mismatchDescription) {
                if (item.content().size() <= position) {
                    mismatchDescription.appendText("Expected at least ").appendValue((Object)position).appendText(" nodes, but the document has only ").appendValue((Object)item.content().size());
                    return false;
                }
                Object node = item.content().get(position);
                if (!nodeType.isInstance(node)) {
                    mismatchDescription.appendText("Expected type ").appendValue((Object)nodeType).appendText(" at position ").appendValue((Object)position).appendText(" but was ").appendValue(node.getClass());
                    return false;
                }
                boolean result = nodeMatcher.matches(node);
                if (!result) {
                    nodeMatcher.describeMismatch(node, mismatchDescription);
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("A document with the following node at position ").appendValue((Object)position).appendText(": ").appendDescriptionOf((SelfDescribing)nodeMatcher);
            }
        };
    }
}

