/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigation.issue;

import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.navigation.issue.AttachmentManagement;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.meterware.httpunit.WebLink;
import net.sourceforge.jwebunit.WebTester;
import org.xml.sax.SAXException;

public class DefaultAttachmentManagement
implements AttachmentManagement {
    private final WebTester tester;
    private final FuncTestLogger logger;
    private static final String ISSUE_KEY_ID = "key-val";

    public DefaultAttachmentManagement(WebTester tester, FuncTestLogger logger) {
        this.tester = tester;
        this.logger = logger;
    }

    @Override
    public void delete() {
        WebLink[] links;
        this.tester.assertElementPresent("manage-attachments");
        IdLocator issueKeyLocator = new IdLocator(this.tester, ISSUE_KEY_ID);
        this.logger.log((Object)("Beginning to delete attachments for issue:  " + issueKeyLocator.getText()));
        try {
            links = this.tester.getDialog().getResponse().getLinks();
        }
        catch (SAXException e) {
            throw new RuntimeException("Error while trying to parse the links of the Manage Attachments page", e);
        }
        for (WebLink link : links) {
            if (!link.getID().startsWith("del_")) continue;
            this.tester.clickLink(link.getID());
            this.tester.submit("Delete");
        }
        this.logger.log((Object)("Finished deleting attachments for issue:  " + issueKeyLocator.getText()));
    }

    @Override
    public String downloadAttachmentAsString(long id, String title) {
        this.tester.gotoPage("/secure/attachment/" + id + "/" + title);
        return this.tester.getDialog().getResponseText();
    }
}

