/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigator;

import com.atlassian.jira.functest.framework.navigator.SearchResultsCondition;
import com.meterware.httpunit.WebTable;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Fail;
import org.xml.sax.SAXException;

public class IssueTableHasColumnCondition
implements SearchResultsCondition {
    private final String columnName;

    public IssueTableHasColumnCondition(String columnName) {
        this.columnName = columnName;
    }

    @Override
    public void assertCondition(WebTester tester) {
        WebTable table = this.getIssueTable(tester);
        if (table == null) {
            Fail.fail((String)"Unable to find issue table");
        }
        if (!this.isColumnPresent(table)) {
            Fail.fail((String)("Unable to find column " + this.columnName + " visible on issue table"));
        }
    }

    WebTable getIssueTable(WebTester tester) {
        try {
            return tester.getDialog().getResponse().getTableWithID("issuetable");
        }
        catch (SAXException e) {
            return null;
        }
    }

    boolean isColumnPresent(WebTable table) {
        for (int i = 0; i < table.getColumnCount(); ++i) {
            String cellText = StringUtils.trimToNull((String)table.getCellAsText(0, i));
            if (!this.columnName.equals(cellText)) continue;
            return true;
        }
        return false;
    }
}

