/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigator;

import com.atlassian.jira.functest.framework.navigator.IssueTypeCondition;
import com.atlassian.jira.functest.framework.navigator.NavigatorCondition;
import com.atlassian.jira.functest.framework.navigator.NavigatorSearch;
import com.atlassian.jira.functest.framework.navigator.ProjectCondition;
import com.atlassian.jira.functest.framework.navigator.QuerySearchCondition;
import java.util.ArrayList;

public class NavigatorSearchBuilder {
    private ProjectCondition projectCondition = null;
    private IssueTypeCondition issueTypeCondition = null;
    private QuerySearchCondition queryCondition = null;

    public NavigatorSearchBuilder addProject(String project) {
        this.getProjectCondition().addProject(project);
        return this;
    }

    private ProjectCondition getProjectCondition() {
        if (this.projectCondition == null) {
            this.projectCondition = new ProjectCondition();
        }
        return this.projectCondition;
    }

    public NavigatorSearchBuilder addIssueType(String type) {
        this.getIssueTypeCondition().addIssueType(type);
        return this;
    }

    public NavigatorSearchBuilder addIssueType(IssueTypeCondition.IssueType type) {
        this.getIssueTypeCondition().addIssueType(type);
        return this;
    }

    private IssueTypeCondition getIssueTypeCondition() {
        if (this.issueTypeCondition == null) {
            this.issueTypeCondition = new IssueTypeCondition();
        }
        return this.issueTypeCondition;
    }

    public NavigatorSearchBuilder addQueryString(String query) {
        this.getQueryCondition().setQueryString(query);
        return this;
    }

    private QuerySearchCondition getQueryCondition() {
        if (this.queryCondition == null) {
            this.queryCondition = new QuerySearchCondition();
        }
        return this.queryCondition;
    }

    public NavigatorSearch createSearch() {
        ArrayList<NavigatorCondition> conditions = new ArrayList<NavigatorCondition>();
        if (this.projectCondition != null) {
            conditions.add(this.projectCondition.copyCondition());
        }
        if (this.issueTypeCondition != null) {
            conditions.add(this.issueTypeCondition.copyCondition());
        }
        if (this.queryCondition != null) {
            conditions.add(this.queryCondition.copyCondition());
        }
        return new NavigatorSearch(conditions);
    }
}

