/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.page;

import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.webtests.table.HtmlTable;
import com.meterware.httpunit.WebTable;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;

public class IssueSearchPage {
    private final WebTester tester;
    private final LocatorFactory locators;

    @Inject
    public IssueSearchPage(WebTester tester, LocatorFactory locators) {
        this.tester = tester;
        this.locators = locators;
    }

    public boolean hasResultsTable() {
        return this.locators.id("issuetable").exists();
    }

    public HtmlTable getResultsTable() {
        WebTable webTable = this.tester.getDialog().getWebTableBySummaryOrId("issuetable");
        return new HtmlTable(webTable);
    }

    public List<String> getResultsIssueKeys() {
        ArrayList<String> issueKeys = new ArrayList<String>();
        for (HtmlTable.Row row : this.getResultsTable().getRows()) {
            if (row.getRowIndex() <= 0) continue;
            issueKeys.add(row.getCellForHeading("Key"));
        }
        return issueKeys;
    }

    public String getWarning() {
        CssLocator warning = this.locators.css("aui-message.aui-message-warning");
        return warning.exists() ? warning.getText() : null;
    }
}

