/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.page;

import com.atlassian.jira.functest.framework.LocatorFactory;
import org.w3c.dom.Element;

public class ViewProfilePage {
    private final LocatorFactory locator;

    public ViewProfilePage(LocatorFactory locator) {
        this.locator = locator;
    }

    public String getUsername() {
        return this.getFieldValue(Section.DETAILS.field("username"));
    }

    public String getFullName() {
        return this.getFieldValue(Section.DETAILS.field("fullname"));
    }

    public String getEmailAddress() {
        return this.getFieldValue(Section.DETAILS.field("email"));
    }

    public String getChangePasswordLink() {
        Element link = (Element)this.locator.id("view_change_password").getNode();
        return link != null ? link.getAttribute("href") : null;
    }

    public int getPageSize() {
        return Integer.parseInt(this.getFieldValue(Section.PREFERENCES.field("pagesize")));
    }

    public String getEmailType() {
        return this.getFieldValue(Section.PREFERENCES.field("mimetype"));
    }

    public String getLanguage() {
        return this.getFieldValue(Section.PREFERENCES.field("locale"));
    }

    public String getFieldValue(String id) {
        String value = this.locator.id(id).getText();
        return value == null ? null : value.trim();
    }

    static enum Section {
        DETAILS('d'),
        PREFERENCES('p');

        private final char sectionKey;

        private Section(char sectionKey) {
            this.sectionKey = sectionKey;
        }

        String field(String fieldName) {
            return "up-" + this.sectionKey + '-' + fieldName;
        }
    }
}

