/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.parser;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.LocatorEntry;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.parser.SystemInfoParser;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import java.util.HashMap;
import java.util.Iterator;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.w3c.dom.Element;

public class SystemInfoParserImpl
implements SystemInfoParser {
    private final WebTester tester;

    @Inject
    public SystemInfoParserImpl(WebTester tester, Navigation navigation) {
        this.tester = tester;
    }

    public SystemInfoParserImpl(WebTester tester, JIRAEnvironmentData environmentData, int logIndentLevel, Navigation navigation) {
        this.tester = tester;
    }

    @Override
    public SystemInfoParser.SystemInfo getSystemInfo() {
        this.tester.gotoPage("secure/admin/jira/ViewSystemInfo.jspa");
        XPathLocator loc = new XPathLocator(this.tester, "//table[@id='system_info_table']/tbody/tr/td");
        int count = 0;
        String key = "";
        final HashMap<String, String> sysInfoMap = new HashMap<String, String>();
        Iterator<LocatorEntry> iterator = loc.iterator();
        while (iterator.hasNext()) {
            LocatorEntry entry = iterator.next();
            Element td = (Element)entry.getNode();
            if (td.hasAttribute("colspan")) continue;
            if (count % 2 == 0) {
                key = entry.getText();
            } else {
                String value = entry.getText().trim();
                sysInfoMap.put(key, value);
            }
            ++count;
        }
        return new SystemInfoParser.SystemInfo(){

            @Override
            public String getAppServer() {
                return this.getProperty("Application Server Container");
            }

            @Override
            public String getJavaVersion() {
                return this.getProperty("JVM Version");
            }

            @Override
            public String getDatabaseType() {
                return this.getProperty("Database type");
            }

            @Override
            public String getSystemEncoding() {
                return this.getProperty("System Encoding");
            }

            @Override
            public String getProperty(String displayedKey) {
                String s = (String)sysInfoMap.get(displayedKey);
                return s == null ? "" : s;
            }
        };
    }
}

