/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.parser.dashboard;

import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.parser.dashboard.DashboardItem;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.w3c.dom.Node;

public class DashboardTableParser {
    private final LocatorFactory locators;

    public DashboardTableParser(LocatorFactory locators) {
        this.locators = locators;
    }

    public List<DashboardItem> parse(String tableId) {
        return this.parse(this.locators.css("#" + tableId).getNode());
    }

    private List<DashboardItem> parse(Node dashboardTableNode) {
        CssLocator cssLocator = this.locatorForDashboardRows(dashboardTableNode);
        List<Node> filterNodes = Arrays.asList(cssLocator.getNodes());
        return Lists.transform(filterNodes, this::parseDashboardItem);
    }

    private DashboardItem parseDashboardItem(Node dashboardNode) {
        return new DashboardItem.Builder().id(new ParseDashboardId().apply(dashboardNode)).name(new ParseDashboardName().apply(dashboardNode)).description(new ParseDashboardDescription().apply(dashboardNode)).owner(new ParseDashboardOwner().apply(dashboardNode)).build();
    }

    private CssLocator locatorForDashboardRows(Node dashboardTableNode) {
        return new CssLocator(dashboardTableNode, "tbody tr");
    }

    private static class ParseDashboardId
    implements Function<Node, Long> {
        private ParseDashboardId() {
        }

        @Override
        public Long apply(@Nullable Node dashboardRowNode) {
            Assertions.notNull("Can not retrieve a dashboard id from a ''null'' DOM Node", dashboardRowNode);
            return Long.valueOf(dashboardRowNode.getAttributes().getNamedItem("id").getNodeValue().substring(3));
        }
    }

    private static class ParseDashboardOwner
    implements Function<Node, String> {
        static final String NO_OWNER_INFO = "";

        private ParseDashboardOwner() {
        }

        @Override
        public String apply(@Nullable Node input) {
            CssLocator filterDescriptionLocator = new CssLocator(input, "td [data-field=owner]");
            if (filterDescriptionLocator.exists()) {
                return filterDescriptionLocator.getText();
            }
            return NO_OWNER_INFO;
        }
    }

    private static class ParseDashboardDescription
    implements Function<Node, String> {
        public static final String EMPTY_DESCRIPTION = "";

        private ParseDashboardDescription() {
        }

        @Override
        public String apply(@Nullable Node input) {
            CssLocator filterDescriptionLocator = new CssLocator(input, "td [data-field=description]");
            if (filterDescriptionLocator.exists()) {
                return filterDescriptionLocator.getText();
            }
            return EMPTY_DESCRIPTION;
        }
    }

    private static class ParseDashboardName
    implements Function<Node, String> {
        private ParseDashboardName() {
        }

        @Override
        public String apply(@Nullable Node input) {
            return new CssLocator(input, "td [id^=dashboardlink]").getText();
        }
    }
}

