/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.security.xsrf;

import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.log.FuncTestLoggerImpl;
import com.meterware.httpunit.SubmitButton;
import com.meterware.httpunit.WebClient;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;
import net.sourceforge.jwebunit.WebTester;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class XsrfCheck {
    public static final String ATL_TOKEN = "atl_token";
    public static final String XSRF_DEFAULT_ERROR = "SecurityTokenMissing";
    public static final String CODE_403_DEFAULT_ERROR = "HTTPError403";
    private final String description;
    private final Setup setup;
    private final Submission submission;
    private Navigation navigation;
    private WebTester tester;
    private Form form;
    private final FuncTestLogger logger;
    private boolean initCalled = false;

    public XsrfCheck(String description, Setup setup, Submission submission) {
        this.description = description;
        this.setup = setup;
        this.submission = submission;
        this.logger = new FuncTestLoggerImpl(2);
    }

    protected void init(WebTester tester, Navigation navigation, Form form) {
        this.tester = tester;
        this.navigation = navigation;
        this.form = form;
        this.submission.init(tester, navigation, form);
        this.initCalled = true;
    }

    public void run() throws Exception {
        this.run(XSRF_DEFAULT_ERROR, CODE_403_DEFAULT_ERROR);
    }

    public void run(String xsrfError, String code403Error) throws Exception {
        if (!this.initCalled) {
            throw new IllegalStateException("init() must be called before running the check!");
        }
        this.logger.log((Object)("STARTING: " + this.description));
        this.setupStep();
        this.logger.log((Object)"\t SUBMITTING DODGY TOKEN");
        this.submission.removeToken();
        this.submission.submitRequest();
        this.getTester().assertTextPresent(xsrfError);
        this.getTester().assertTextNotPresent(code403Error);
        this.setupStep();
        this.logger.log((Object)"\t SUBMITTING DODGY TOKEN FROM INVALID ORIGIN");
        this.submission.removeToken();
        WebResponse resp = this.submission.submitRequest("http://example.com");
        Assertions.assertThat((int)resp.getResponseCode()).isEqualTo(403);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.isTextInResponse(resp, xsrfError)).overridingErrorMessage("Text found in response when not expected: [" + xsrfError + "]", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.isTextInResponse(resp, code403Error)).overridingErrorMessage("Expected text not found in response: [" + code403Error + "]", new Object[0])).isTrue();
        this.setupStep();
        this.logger.log((Object)"\t SUBMITTING VALID TOKEN");
        this.submission.submitRequest();
        this.getTester().assertTextNotPresent(xsrfError);
        this.getTester().assertTextNotPresent(code403Error);
        this.logger.log((Object)("COMPLETED: " + this.description));
    }

    private void setupStep() {
        this.logger.log((Object)"\t SETUP");
        this.getTester().gotoPage("");
        this.setup.setup();
    }

    private WebTester getTester() {
        return this.tester;
    }

    private Navigation getNavigation() {
        return this.navigation;
    }

    private Form getForm() {
        return this.form;
    }

    private boolean isTextInResponse(WebResponse resp, String text) throws IOException {
        return resp.getText().indexOf(text) >= 0;
    }

    public static String invalidTokenInUrl(String original) {
        int startIndex = original.indexOf(ATL_TOKEN);
        if (startIndex != -1) {
            StringBuilder sb = new StringBuilder(original);
            sb.insert(startIndex + ATL_TOKEN.length() + 1, "invalidToken");
            return sb.toString();
        }
        return original;
    }

    public static class CssLocatorLinkSubmission
    extends AbstractLinkSubmission {
        private final int index;
        private final String cssExpression;
        private String originalUrl;

        public CssLocatorLinkSubmission(String cssExpression, int index) {
            this.cssExpression = cssExpression;
            this.index = index;
        }

        public CssLocatorLinkSubmission(String cssExpression) {
            this(cssExpression, 0);
        }

        @Override
        public String getLink() throws Exception {
            if (this.originalUrl == null) {
                CssLocator locator = new CssLocator(super.getTester(), this.cssExpression);
                Node[] nodes = locator.getNodes();
                if (this.index >= nodes.length) {
                    Fail.fail((String)String.format("Unable to find link %d at '%s'.", this.index, this.cssExpression));
                }
                this.originalUrl = ((Attr)nodes[this.index].getAttributes().getNamedItem("href")).getValue();
            }
            return this.originalUrl;
        }
    }

    public static class XPathLinkSubmission
    extends AbstractLinkSubmission {
        private final String xPathExpression;
        private String originalUrl;

        public XPathLinkSubmission(String xPathExpression) {
            this.xPathExpression = xPathExpression;
        }

        @Override
        public String getLink() throws Exception {
            if (this.originalUrl == null) {
                XPathLocator locator = new XPathLocator(super.getTester(), this.xPathExpression);
                Node node = locator.getNode();
                com.atlassian.jira.util.dbc.Assertions.notNull("node not found for xPathExpression [" + this.xPathExpression + "]", node);
                this.originalUrl = ((Attr)node.getAttributes().getNamedItem("href")).getValue();
            }
            return this.originalUrl;
        }
    }

    public static class LinkWithTextSubmission
    extends AbstractLinkSubmission {
        private final String linkText;
        private String originalUrl;

        public LinkWithTextSubmission(String linkText) {
            this.linkText = linkText;
        }

        @Override
        public String getLink() throws Exception {
            if (this.originalUrl == null) {
                WebLink link = super.getTester().getDialog().getResponse().getLinkWith(this.linkText);
                com.atlassian.jira.util.dbc.Assertions.notNull("link", link);
                this.originalUrl = link.getURLString();
            }
            return this.originalUrl;
        }
    }

    public static class SuppliedLinkSubmission
    extends AbstractLinkSubmission {
        private String originalUrl;
        private Supplier<String> urlSupplier;

        public SuppliedLinkSubmission(Supplier<String> urlSupplier) {
            this.urlSupplier = Objects.requireNonNull(urlSupplier);
        }

        @Override
        public String getLink() throws Exception {
            if (this.originalUrl == null) {
                this.originalUrl = Objects.requireNonNull(this.urlSupplier.get());
            }
            return this.originalUrl;
        }
    }

    public static class LinkWithIdSubmission
    extends AbstractLinkSubmission {
        private final String linkId;
        private String originalUrl;

        public LinkWithIdSubmission(String linkId) {
            this.linkId = linkId;
        }

        @Override
        public String getLink() throws Exception {
            if (this.originalUrl == null) {
                WebLink link = super.getTester().getDialog().getResponse().getLinkWithID(this.linkId);
                com.atlassian.jira.util.dbc.Assertions.notNull("link", link);
                this.originalUrl = link.getURLString();
            }
            return this.originalUrl;
        }
    }

    public static abstract class AbstractLinkSubmission
    extends BaseSubmission
    implements Submission {
        private String urlToSubmit;

        @Override
        public void init(WebTester tester, Navigation navigation, Form form) {
            super.init(tester, navigation, form);
            this.resetReferer();
        }

        public abstract String getLink() throws Exception;

        @Override
        public void removeToken() throws Exception {
            this.urlToSubmit = XsrfCheck.invalidTokenInUrl(this.getLink());
        }

        @Override
        public void submitRequest() throws Exception {
            super.getTester().gotoPage(this.urlToSubmit);
            this.urlToSubmit = this.getLink();
        }

        @Override
        public WebResponse submitRequest(String referer) throws Exception {
            this.setReferer(referer);
            this.submitRequest();
            this.resetReferer();
            return super.getTester().getDialog().getResponse();
        }

        private void setReferer(String url) {
            super.getTester().getTestContext().getWebClient().setHeaderField("Referer", url);
        }

        private void resetReferer() {
            this.setReferer(super.getTester().getTestContext().getBaseUrl());
        }
    }

    public static class FormSubmissionWithId
    extends AbstractFormSubmission {
        private final String submitId;

        public FormSubmissionWithId(String submitId) {
            this.submitId = submitId;
        }

        @Override
        public void submitRequest() {
            super.getTester().clickButton(this.submitId);
        }

        @Override
        protected SubmitButton getButton() {
            WebTester tester = super.getTester();
            tester.assertButtonPresent(this.submitId);
            return tester.getDialog().getForm().getSubmitButtonWithID(this.submitId);
        }
    }

    public static class FormSubmission
    extends AbstractFormSubmission {
        private final String submitName;

        public FormSubmission(String submitName) {
            this.submitName = submitName;
        }

        @Override
        public void submitRequest() {
            super.getTester().submit(this.submitName);
        }

        @Override
        protected SubmitButton getButton() {
            WebTester tester = super.getTester();
            tester.assertSubmitButtonPresent(this.submitName);
            return tester.getDialog().getSubmitButton(this.submitName);
        }
    }

    public static abstract class AbstractFormSubmission
    extends BaseSubmission
    implements Submission {
        @Override
        public void removeToken() {
            for (WebForm webForm : this.getForm().getForms()) {
                if (webForm.hasParameterNamed(XsrfCheck.ATL_TOKEN)) {
                    webForm.getScriptableObject().setParameterValue(XsrfCheck.ATL_TOKEN, "invalidToken");
                }
                webForm.getScriptableObject().setAction(XsrfCheck.invalidTokenInUrl(webForm.getAction()));
            }
        }

        protected abstract SubmitButton getButton();

        @Override
        public WebResponse submitRequest(String referer) {
            SubmitButton submit = this.getButton();
            WebRequest request = super.getTester().getDialog().getForm().getRequest(submit);
            WebClient webClient = super.getTester().getTestContext().getWebClient();
            request.setHeaderField("Referer", referer);
            try {
                return webClient.sendRequest(request);
            }
            catch (Exception e) {
                Fail.fail((String)String.format("Exception thrown: %s", e.getMessage()));
                return null;
            }
        }
    }

    static abstract class BaseSubmission
    implements Submission {
        private WebTester tester;
        private Navigation navigation;
        private Form form;

        BaseSubmission() {
        }

        @Override
        public void init(WebTester tester, Navigation navigation, Form form) {
            this.tester = tester;
            this.navigation = navigation;
            this.form = form;
        }

        WebTester getTester() {
            return this.tester;
        }

        Navigation getNavigation() {
            return this.navigation;
        }

        Form getForm() {
            return this.form;
        }
    }

    public static interface Submission {
        public void init(WebTester var1, Navigation var2, Form var3);

        public void removeToken() throws Exception;

        public void submitRequest() throws Exception;

        public WebResponse submitRequest(String var1) throws Exception;
    }

    public static interface Setup {
        public void setup();

        public static final class None
        implements Setup {
            @Override
            public void setup() {
            }
        }
    }
}

