/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.security.xsrf;

import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.jwebunit.WebTester;

public class XsrfTestSuite {
    private final List<XsrfCheck> checks;

    public XsrfTestSuite(Collection<XsrfCheck> checks) {
        if (checks == null || checks.isEmpty()) {
            throw new IllegalArgumentException("Please pass in at least one XsrfCheck");
        }
        this.checks = ImmutableList.copyOf(checks);
    }

    public XsrfTestSuite(XsrfCheck ... checks) {
        if (checks == null || checks.length == 0) {
            throw new IllegalArgumentException("Please pass in at least one XsrfCheck");
        }
        this.checks = ImmutableList.copyOf((Object[])checks);
    }

    public void run(WebTester tester, Navigation navigation, Form form) throws Exception {
        for (XsrfCheck check : this.checks) {
            check.init(tester, navigation, form);
            check.run();
        }
    }

    public void run(WebTester tester, Navigation navigation, Form form, String xsrfError) throws Exception {
        for (XsrfCheck check : this.checks) {
            check.init(tester, navigation, form);
            check.run(xsrfError, "HTTPError403");
        }
    }
}

