/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.setup;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import org.testcontainers.containers.InternetProtocol;
import org.testcontainers.containers.PostgreSQLContainer;

public class PostgresContainer
extends PostgreSQLContainer {
    private static final String POSTGRES_14_4 = "postgres:14.4";
    private static final int MAX_RETRIES_FREE_PORT_OBTAIN = 5;
    private String databaseName = "test";
    private final List<String> addArgs = new ArrayList<String>();

    public PostgresContainer() {
        this(POSTGRES_14_4);
        this.addFixedExposedPort(this.findFreePort(), POSTGRESQL_PORT, InternetProtocol.TCP);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int findFreePort() {
        int tries = 0;
        IOException lastException = null;
        while (tries++ < 5) {
            try (ServerSocket socket = new ServerSocket(0);){
                int n = socket.getLocalPort();
                return n;
            }
            catch (IOException e) {
                lastException = e;
            }
        }
        throw new RuntimeException("Cannot obtain free port after " + tries + " tries", lastException);
    }

    public PostgresContainer(String dockerImageName) {
        super(dockerImageName);
    }

    public PostgresContainer addArgument(String argValue) {
        this.addArgs.add(argValue);
        return this;
    }

    public PostgresContainer setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public void stopForRestart() {
        this.dockerClient.stopContainerCmd(this.getContainerId()).exec();
    }

    public void startForRestart() {
        this.dockerClient.startContainerCmd(this.getContainerId()).exec();
    }

    protected void configure() {
        super.configure();
        this.addEnv("POSTGRES_DATABASE", this.databaseName);
        this.setStartupAttempts(1);
    }

    public String getJdbcUrl() {
        return super.getJdbcUrl().replace("/test", "/" + this.databaseName);
    }
}

