/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.sharing;

import com.atlassian.jira.functest.framework.sharing.SimpleTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermission;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class GroupTestSharingPermission
implements TestSharingPermission {
    public static final String TYPE = "group";
    private final String group;

    public GroupTestSharingPermission(SimpleTestSharingPermission permission) {
        if (!TYPE.equals(permission.getType())) {
            throw new IllegalArgumentException();
        }
        this.group = permission.getPerm1() == null ? "" : permission.getPerm1();
    }

    public GroupTestSharingPermission(String group) {
        this.group = group == null ? "" : group;
    }

    public String getGroup() {
        return this.group;
    }

    public String toString() {
        return "Group Share: [Group: " + this.group + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupTestSharingPermission that = (GroupTestSharingPermission)o;
        return this.group.equals(that.group);
    }

    public int hashCode() {
        return this.group.hashCode();
    }

    @Override
    public JSONObject toJson() {
        try {
            JSONObject object = new JSONObject();
            object.put("type", TYPE);
            if (!StringUtils.isBlank((CharSequence)this.group)) {
                object.put("param1", this.group);
            }
            return object;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public static GroupTestSharingPermission parseJson(JSONObject json) throws JSONException {
        String type;
        if (json.has("type") && TYPE.equals(type = (String)json.get("type"))) {
            String group = null;
            if (json.has("param1")) {
                group = (String)json.get("param1");
            }
            return new GroupTestSharingPermission(group);
        }
        return null;
    }

    @Override
    public String toDisplayFormat() {
        return "Group: " + this.getGroup();
    }

    @Override
    public String toDisplayFormatUnknown() {
        return "Group: [UNKNOWN]";
    }
}

