/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.sharing;

import com.atlassian.jira.functest.framework.sharing.AuthenticatedTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.GlobalTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.GroupTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.ProjectTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.SimpleTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermission;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class TestSharingPermissionUtils {
    public static Set<TestSharingPermission> parsePermissions(String json) throws JSONException {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        JSONArray array = new JSONArray(json);
        HashSet<GlobalTestSharingPermission> returnSet = new HashSet<GlobalTestSharingPermission>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject object = array.getJSONObject(i);
            TestSharingPermission permission = GlobalTestSharingPermission.parseJson(object);
            if (permission == null) {
                permission = AuthenticatedTestSharingPermission.parseJson(object);
            }
            if (permission == null) {
                permission = GroupTestSharingPermission.parseJson(object);
            }
            if (permission == null) {
                permission = ProjectTestSharingPermission.parseJson(object);
            }
            if (permission == null) {
                permission = SimpleTestSharingPermission.parseJson(object);
            }
            if (permission == null) {
                throw new JSONException("JSON does not contain valid share permissions.");
            }
            returnSet.add((GlobalTestSharingPermission)permission);
        }
        return Collections.unmodifiableSet(returnSet);
    }

    public static String createJsonString(Set<? extends TestSharingPermission> permissions) {
        JSONArray array = new JSONArray();
        for (TestSharingPermission testSharingPermission : permissions) {
            array.put(testSharingPermission.toJson());
        }
        return array.toString();
    }

    public static Set<TestSharingPermission> createPublicPermissions() {
        return Collections.singleton(GlobalTestSharingPermission.GLOBAL_PERMISSION);
    }

    public static Set<TestSharingPermission> createAuthenticatedPermissions() {
        return Collections.singleton(AuthenticatedTestSharingPermission.AUTHENTICATED_USER_PERMISSION);
    }

    public static Set<TestSharingPermission> createGroupPermissions(String group) {
        return Collections.singleton(new GroupTestSharingPermission(group));
    }

    public static Set<TestSharingPermission> createProjectPermissions(long projId, long roleId, String projectName, String roleName) {
        return Collections.singleton(new ProjectTestSharingPermission(projId, roleId, projectName, roleName));
    }

    public static Set<TestSharingPermission> createPrivatePermissions() {
        return Collections.emptySet();
    }
}

