/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.suite;

import com.atlassian.jira.functest.framework.FuncTestSuite;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.suite.WebTestSuite;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.webtests.util.ClassLocator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class CategoryBasedSuite
implements WebTestSuite,
Supplier<FuncTestSuite> {
    private final String testPackage;
    private final Set<Category> includes;
    private final Set<Category> excludes;

    public CategoryBasedSuite(String testPackage, Set<Category> includes, Set<Category> excludes) {
        Preconditions.checkNotNull((Object)testPackage);
        this.testPackage = testPackage;
        this.includes = includes == null ? ImmutableSet.of() : includes;
        this.excludes = excludes == null ? ImmutableSet.of() : excludes;
    }

    @Override
    public String webTestPackage() {
        return this.testPackage;
    }

    @Override
    public Set<Category> includes() {
        return this.includes;
    }

    @Override
    public Set<Category> excludes() {
        return this.excludes;
    }

    @Override
    public FuncTestSuite get() {
        FuncTestSuite testSuite = new FuncTestSuite();
        this.getClassesFromPackages().forEach(testSuite::addTest);
        return testSuite;
    }

    private Stream<Class<?>> getClassesFromPackages() {
        List<String> packages = Arrays.asList(this.testPackage.split(","));
        return packages.stream().map(p -> new ClassLocator<Object>(Object.class).setAllowInner(true).setPredicate(new TestPredicate()).setPackage((String)p).findClasses()).flatMap(Collection::stream).filter(this::hasCorrectCategoryAnnotation).sorted(Comparator.comparing(Class::getCanonicalName)).distinct();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    protected boolean hasCorrectCategoryAnnotation(Class<?> clazz) {
        Set<Category> categories = this.getDirectCategories(clazz);
        if (!categories.containsAll(this.includes)) return false;
        if (categories.stream().filter(this.excludes::contains).findAny().isPresent()) return false;
        return true;
    }

    private Set<Category> getDirectCategories(Class<?> clazz) {
        WebTest annotation = clazz.getAnnotation(WebTest.class);
        if (annotation == null || annotation.value().length == 0) {
            return EnumSet.noneOf(Category.class);
        }
        return EnumSet.copyOf(Arrays.asList(annotation.value()));
    }

    private class TestPredicate
    implements Predicate<Class<?>> {
        private TestPredicate() {
        }

        @Override
        public boolean evaluate(Class<?> input) {
            return Modifier.isPublic(input.getModifiers()) && !Modifier.isAbstract(input.getModifiers());
        }
    }
}

