/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.suite;

import com.atlassian.jira.functest.framework.suite.ParentRunnerHacker;
import com.atlassian.jira.functest.framework.suite.SuiteTransform;
import com.atlassian.jira.functest.framework.suite.TransformingParentRunner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runners.ParentRunner;

public final class RunnerChildList<T> {
    private final ParentRunnerHacker<T> hacker;
    private final List<T> children;
    private final List<Description> descriptions;

    public RunnerChildList(ParentRunner<T> parentRunner) {
        this.hacker = new ParentRunnerHacker<T>(parentRunner);
        this.children = this.hacker.getChildren();
        this.descriptions = this.getDescriptions(parentRunner);
    }

    private List<Description> getDescriptions(ParentRunner parentRunner) {
        ArrayList answer = Lists.newArrayList();
        ParentRunnerHacker<T> hacker = new ParentRunnerHacker<T>(parentRunner);
        for (T child : this.children) {
            answer.add(hacker.describeChild(child));
        }
        return answer;
    }

    public List<T> children() {
        return Lists.newArrayList(this.children);
    }

    public List<Description> descriptions() {
        return Lists.newArrayList(this.descriptions);
    }

    public List<T> matchingChildren(List<Description> transformedDescriptions) {
        ArrayList answer = Lists.newArrayList();
        for (Description desc : transformedDescriptions) {
            answer.add(this.children.get(this.descriptions.indexOf(desc)));
        }
        return answer;
    }

    public static <T> List<T> matchingChildren(List<T> originalChildren, List<Description> originalDescriptions, Iterable<SuiteTransform> suiteTransforms) {
        List<Description> transformedDescriptions = TransformingParentRunner.applyTransforms(originalDescriptions, suiteTransforms);
        ArrayList answer = Lists.newArrayList();
        for (Description desc : transformedDescriptions) {
            answer.add(originalChildren.get(originalDescriptions.indexOf(desc)));
        }
        return answer;
    }
}

