/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.suite;

import com.atlassian.jira.functest.framework.FuncTestSuite;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.CategoryBasedSuite;
import com.atlassian.jira.functest.framework.suite.WebTestSuite;
import com.atlassian.jira.functest.framework.suite.WebTestSuiteRunner;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.junit.runner.RunWith;

@RunWith(value=WebTestSuiteRunner.class)
public class SystemPropertyBasedSuite
implements WebTestSuite,
Supplier<FuncTestSuite> {
    private static final String PACKAGE_PROPERTY_NAME = "atlassian.test.suite.package";
    private static final String INCLUDES_PROPERTY_NAME = "atlassian.test.suite.includes";
    private static final String EXCLUDES_PROPERTY_NAME = "atlassian.test.suite.excludes";
    private final String packageName = Assertions.notNull(System.getProperty("atlassian.test.suite.package")).trim();
    private final CategoryBasedSuite categoryBasedSuite = new CategoryBasedSuite(this.packageName, this.toCategories("atlassian.test.suite.includes"), this.toCategories("atlassian.test.suite.excludes"));

    @Override
    public String webTestPackage() {
        return this.packageName;
    }

    @Override
    public Set<Category> includes() {
        return this.categoryBasedSuite.includes();
    }

    @Override
    public Set<Category> excludes() {
        return this.categoryBasedSuite.excludes();
    }

    @Override
    public FuncTestSuite get() {
        return this.categoryBasedSuite.get();
    }

    private Set<Category> toCategories(String propName) {
        EnumSet<Category> answer = EnumSet.noneOf(Category.class);
        for (String each : this.splitList(System.getProperty(propName))) {
            answer.add(Category.forString(each));
        }
        return answer;
    }

    private List<String> splitList(String list) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String each : Arrays.asList(list.split(","))) {
            String trimmed = each.trim();
            if (!StringUtils.isNotBlank((CharSequence)trimmed)) continue;
            result.add(trimmed);
        }
        return result;
    }
}

