/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.util;

import com.atlassian.jira.functest.framework.util.IssueTable;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

public class IssueTableClient
extends RestApiClient<IssueTableClient> {
    private final com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData;

    public IssueTableClient(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
        super((JIRAEnvironmentData)environmentData);
        this.environmentData = environmentData;
    }

    public ClientIssueTableServiceOutcome getIssueTable(Long filterId) {
        return this.getIssueTable(filterId, null, null, null, true);
    }

    public ClientIssueTableServiceOutcome getIssueTable(String jql) {
        return this.getIssueTable(null, jql, null, null, true);
    }

    public ClientIssueTableServiceOutcome setSessionSearch(String jql) {
        return this.getIssueTable(null, jql, null, null, true);
    }

    public ClientIssueTableServiceOutcome getIssueTable(Long filterId, String jql, String num, Integer startIndex, Boolean useUserColumns) {
        return (ClientIssueTableServiceOutcome)this.createResource().request().header("X-Atlassian-Token", (Object)"no-check").post(Entity.form((MultivaluedMap)this.getPostData(filterId, jql, num, startIndex, useUserColumns)), ClientIssueTableServiceOutcome.class);
    }

    public ParsedResponse<String> getResponse(Long filterId, String jql, String num, Integer startIndex, Boolean useUserColumns) {
        return this.toResponse(() -> (Response)this.createResource().request().header("X-Atlassian-Token", (Object)"no-check").post(Entity.form((MultivaluedMap)this.getPostData(filterId, jql, num, startIndex, useUserColumns)), Response.class), String.class);
    }

    public ParsedResponse<String> getResponse(Long filterId) {
        return this.toResponse(() -> (Response)this.createResource().request().header("X-Atlassian-Token", (Object)"no-check").post(Entity.form((MultivaluedMap)this.getPostData(filterId, null, null, null, true)), Response.class), String.class);
    }

    private MultivaluedMap getPostData(Long filterId, String jql, String num, Integer startIndex, Boolean useUserColumns) {
        String columnConfig = null;
        if (null != useUserColumns) {
            columnConfig = useUserColumns != false ? "user" : "filter";
        }
        return this.getPostData(filterId, jql, num, startIndex, columnConfig);
    }

    private MultivaluedMap getPostData(Long filterId, String jql, String num, Integer startIndex, String columnConfig) {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        if (null != filterId) {
            formData.add((Object)"filterId", (Object)filterId.toString());
        }
        if (null != jql) {
            formData.add((Object)"jql", (Object)jql);
        }
        if (null != num) {
            formData.add((Object)"num", (Object)num);
        }
        if (null != startIndex) {
            formData.add((Object)"startIndex", (Object)String.valueOf(startIndex));
        }
        if (null != columnConfig) {
            formData.add((Object)"columnConfig", (Object)columnConfig);
        }
        return formData;
    }

    protected WebTarget createResource() {
        return this.resourceRoot(this.environmentData.getBaseUrl().toExternalForm()).path("rest/issueNav/latest/issueTable");
    }

    @XmlRootElement
    public static class ClientIssueTableServiceOutcome {
        @XmlElement
        public IssueTable issueTable;
        @XmlElement
        public List<String> warnings;

        public ClientIssueTableServiceOutcome() {
        }

        public ClientIssueTableServiceOutcome(IssueTable issueTable, Collection<String> warnings) {
            this.issueTable = issueTable;
            this.warnings = new ArrayList<String>(warnings);
        }

        public IssueTable getIssueTable() {
            return this.issueTable;
        }

        public Collection<String> getWarnings() {
            return this.warnings;
        }
    }
}

