/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.util;

import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import javax.ws.rs.core.Response;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ResponseMatchers {
    public static ResponseContainsString responseContains(String string) {
        return new ResponseContainsString(string);
    }

    public static ResponseCodeIs responseCodeIs(int code) {
        return new ResponseCodeIs(code);
    }

    public static Matcher<ParsedResponse> hasStatusCode(Response.Status statusCode) {
        return new ResponseHasStatus(statusCode);
    }

    private static class ResponseHasStatus
    extends TypeSafeMatcher<ParsedResponse>
    implements Matcher<ParsedResponse> {
        private final Response.Status status;

        public ResponseHasStatus(Response.Status status) {
            this.status = status;
        }

        protected boolean matchesSafely(ParsedResponse item) {
            return this.status.getStatusCode() == item.statusCode;
        }

        public void describeTo(Description description) {
            description.appendText("Response with status code ").appendValue((Object)this.status);
        }
    }

    public static class ResponseCodeIs
    extends TypeSafeMatcher<WebResponse> {
        private final int expectedResponseCode;

        public ResponseCodeIs(int expectedResponseCode) {
            this.expectedResponseCode = expectedResponseCode;
        }

        protected boolean matchesSafely(WebResponse item) {
            return item.getResponseCode() == this.expectedResponseCode;
        }

        public void describeTo(Description description) {
            description.appendText("WebResponse code should be ").appendValue((Object)this.expectedResponseCode);
        }
    }

    public static class ResponseContainsString
    extends TypeSafeMatcher<WebResponse> {
        private final String containedString;

        public ResponseContainsString(String containedString) {
            this.containedString = containedString;
        }

        protected boolean matchesSafely(WebResponse item) {
            try {
                return item.getText().contains(this.containedString);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void describeTo(Description description) {
            description.appendText("WebResponse text should contain ").appendValue((Object)this.containedString);
        }
    }
}

