/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.util.env;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.NavigationImpl;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.WebTable;
import java.util.Optional;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.xml.sax.SAXException;

public class EnvironmentUtils {
    private static final String INFO_OS = "Operating System";
    private static final String OS_WINDOWS = "WINDOWS";
    private final WebTester tester;
    private final Navigation navigation;

    public EnvironmentUtils(WebTester tester, JIRAEnvironmentData environmentData) {
        this(tester, environmentData, new NavigationImpl(tester, environmentData));
    }

    @Inject
    public EnvironmentUtils(WebTester tester, JIRAEnvironmentData environmentData, Navigation navigation) {
        this.tester = tester;
        this.navigation = navigation;
    }

    public boolean isOnWindows() {
        return this.isOnOperatingSystem(OS_WINDOWS);
    }

    private boolean isOnOperatingSystem(String os) {
        this.navigation.login("admin", "admin");
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        this.navigation.webSudoAuthenticateUsingLastPassword();
        try {
            WebTable systemInfoTable = this.tester.getDialog().getResponse().getTableWithID("system_info_table");
            for (int i = 0; i < systemInfoTable.getRowCount(); ++i) {
                String key = systemInfoTable.getCellAsText(i, 0);
                if (key == null || !key.contains(INFO_OS)) continue;
                String value = systemInfoTable.getCellAsText(i, 1);
                if (value == null) break;
                return value.toUpperCase().contains(os.toUpperCase());
            }
            throw new RuntimeException("System Info page does not contain 'Operating System' information!");
        }
        catch (SAXException e) {
            throw new RuntimeException("Error parsing the System Infor page", e);
        }
    }

    public boolean isSunJVM() {
        String jvmVendor = this.getSystemInfoProperty("Java VM");
        return jvmVendor != null && jvmVendor.contains("HotSpot");
    }

    public boolean isOracle() {
        return this.isDatabaseTypeContains("oracle");
    }

    public boolean isH2() {
        return this.isDatabaseEqualTo("h2");
    }

    public boolean isHsql() {
        return this.isDatabaseEqualTo("hsql");
    }

    public boolean isMSSQL() {
        return this.isDatabaseEqualTo("mssql");
    }

    public boolean isMySQL() {
        return this.isDatabaseTypeContains("mysql");
    }

    public boolean isPostgres() {
        return this.isDatabaseTypeContains("postgres");
    }

    private boolean isDatabaseEqualTo(String database) {
        String databaseType = this.getDatabaseType();
        return databaseType != null && databaseType.trim().equalsIgnoreCase(database.toLowerCase());
    }

    private boolean isDatabaseTypeContains(String database) {
        String databaseType = this.getDatabaseType();
        return databaseType.toLowerCase().trim().toLowerCase().contains(database.toLowerCase());
    }

    private String getDatabaseType() {
        return this.getSystemInfoProperty("Database type");
    }

    public String getSystemInfoProperty(String propertyLabel) {
        return Optional.ofNullable(this.getPropertyFromTable("system_info_table", propertyLabel)).orElseGet(() -> this.getPropertyFromTable("system_properties_info_table", propertyLabel));
    }

    private String getPropertyFromTable(String tableId, String propertyLabel) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        WebTable table = this.tester.getDialog().getWebTableBySummaryOrId(tableId);
        for (int i = 0; i < table.getRowCount(); ++i) {
            if (!table.getTableCell(i, 0).asText().contains(propertyLabel)) continue;
            return table.getTableCell(i, 1).asText();
        }
        return null;
    }

    public boolean isJvmWithPermGen() {
        String JVM__HTML_TABLE_TD;
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        String responseText = this.tester.getDialog().getResponseText();
        int idx = responseText.indexOf("<strong>Total PermGen Memory</strong>");
        if (idx != -1 && (idx = responseText.indexOf(JVM__HTML_TABLE_TD = "<td class=\"cell-type-value\">", idx)) != -1) {
            String jvmPermGen;
            if ((jvmPermGen = responseText.substring(idx += JVM__HTML_TABLE_TD.length(), responseText.indexOf("</td>", idx))).contains(" ")) {
                jvmPermGen = jvmPermGen.substring(0, jvmPermGen.indexOf(" "));
            }
            try {
                return Float.parseFloat(jvmPermGen) > 0.0f;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }
}

