/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.util.json;

import com.atlassian.jira.functest.framework.util.json.TestJSONException;
import com.atlassian.jira.functest.framework.util.json.TestJSONObject;
import com.atlassian.jira.functest.framework.util.json.TestJSONTokener;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class TestJSONArray {
    private ArrayList myArrayList;

    public TestJSONArray() {
        this.myArrayList = new ArrayList();
    }

    public TestJSONArray(TestJSONTokener x) throws TestJSONException {
        this();
        if (x.nextClean() != '[') {
            x.syntaxError("A JSONArray text must start with '['");
        }
        if (x.nextClean() == ']') {
            return;
        }
        x.back();
        block4: while (true) {
            if (x.nextClean() == ',') {
                x.back();
                this.myArrayList.add(null);
            } else {
                x.back();
                this.myArrayList.add(x.nextValue());
            }
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == ']') {
                        return;
                    }
                    x.back();
                    continue block4;
                }
                case ']': {
                    return;
                }
            }
            x.syntaxError("Expected a ',' or ']'");
        }
    }

    public TestJSONArray(String source) throws TestJSONException {
        this(new TestJSONTokener(source));
    }

    public TestJSONArray(Collection collection) {
        this.myArrayList = collection == null ? new ArrayList() : new ArrayList(collection);
    }

    public TestJSONArray(Object array) throws TestJSONException {
        this();
        if (array.getClass().isArray()) {
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                this.put(Array.get(array, i));
            }
        } else {
            throw new TestJSONException("JSONArray initial value should be a string or collection or array.");
        }
    }

    public Object get(int index) throws TestJSONException {
        Object o = this.opt(index);
        if (o == null) {
            throw new TestJSONException("JSONArray[" + index + "] not found.");
        }
        return o;
    }

    public boolean getBoolean(int index) throws TestJSONException {
        Object o = this.get(index);
        if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase("false")) {
            return false;
        }
        if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase("true")) {
            return true;
        }
        throw new TestJSONException("JSONArray[" + index + "] is not a Boolean.");
    }

    public double getDouble(int index) throws TestJSONException {
        Object o = this.get(index);
        try {
            return o instanceof Number ? ((Number)o).doubleValue() : Double.valueOf((String)o).doubleValue();
        }
        catch (Exception e) {
            throw new TestJSONException("JSONArray[" + index + "] is not a number.");
        }
    }

    public int getInt(int index) throws TestJSONException {
        Object o = this.get(index);
        return o instanceof Number ? ((Number)o).intValue() : (int)this.getDouble(index);
    }

    public TestJSONArray getJSONArray(int index) throws TestJSONException {
        Object o = this.get(index);
        if (o instanceof TestJSONArray) {
            return (TestJSONArray)o;
        }
        throw new TestJSONException("JSONArray[" + index + "] is not a JSONArray.");
    }

    public TestJSONObject getJSONObject(int index) throws TestJSONException {
        Object o = this.get(index);
        if (o instanceof TestJSONObject) {
            return (TestJSONObject)o;
        }
        throw new TestJSONException("JSONArray[" + index + "] is not a JSONObject.");
    }

    public long getLong(int index) throws TestJSONException {
        Object o = this.get(index);
        return o instanceof Number ? ((Number)o).longValue() : (long)this.getDouble(index);
    }

    public String getString(int index) throws TestJSONException {
        return this.get(index).toString();
    }

    public boolean isNull(int index) {
        return TestJSONObject.NULL.isNull(this.opt(index));
    }

    public String join(String separator) throws TestJSONException {
        int len = this.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(TestJSONObject.valueToString(this.myArrayList.get(i)));
        }
        return sb.toString();
    }

    public int length() {
        return this.myArrayList.size();
    }

    public Object opt(int index) {
        return index < 0 || index >= this.length() ? null : this.myArrayList.get(index);
    }

    public boolean optBoolean(int index) {
        return this.optBoolean(index, false);
    }

    public boolean optBoolean(int index, boolean defaultValue) {
        try {
            return this.getBoolean(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double optDouble(int index) {
        return this.optDouble(index, Double.NaN);
    }

    public double optDouble(int index, double defaultValue) {
        try {
            return this.getDouble(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int optInt(int index) {
        return this.optInt(index, 0);
    }

    public int optInt(int index, int defaultValue) {
        try {
            return this.getInt(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public TestJSONArray optJSONArray(int index) {
        Object o = this.opt(index);
        return o instanceof TestJSONArray ? (TestJSONArray)o : null;
    }

    public TestJSONObject optJSONObject(int index) {
        Object o = this.opt(index);
        return o instanceof TestJSONObject ? (TestJSONObject)o : null;
    }

    public long optLong(int index) {
        return this.optLong(index, 0L);
    }

    public long optLong(int index, long defaultValue) {
        try {
            return this.getLong(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String optString(int index) {
        return this.optString(index, "");
    }

    public String optString(int index, String defaultValue) {
        Object o = this.opt(index);
        return o != null ? o.toString() : defaultValue;
    }

    public TestJSONArray put(boolean value) {
        this.put(value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public TestJSONArray put(Collection value) {
        this.put(new TestJSONArray(value));
        return this;
    }

    public TestJSONArray put(double value) throws TestJSONException {
        Double d = new Double(value);
        TestJSONObject.testValidity(d);
        this.put(d);
        return this;
    }

    public TestJSONArray put(int value) {
        this.put(new Integer(value));
        return this;
    }

    public TestJSONArray put(long value) {
        this.put(new Long(value));
        return this;
    }

    public TestJSONArray put(Map value) {
        this.put(new TestJSONObject(value));
        return this;
    }

    public TestJSONArray put(Object value) {
        this.myArrayList.add(value);
        return this;
    }

    public TestJSONArray put(int index, boolean value) throws TestJSONException {
        this.put(index, value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public TestJSONArray put(int index, Collection value) throws TestJSONException {
        this.put(index, new TestJSONArray(value));
        return this;
    }

    public TestJSONArray put(int index, double value) throws TestJSONException {
        this.put(index, new Double(value));
        return this;
    }

    public TestJSONArray put(int index, int value) throws TestJSONException {
        this.put(index, new Integer(value));
        return this;
    }

    public TestJSONArray put(int index, long value) throws TestJSONException {
        this.put(index, new Long(value));
        return this;
    }

    public TestJSONArray put(int index, Map value) throws TestJSONException {
        this.put(index, new TestJSONObject(value));
        return this;
    }

    public TestJSONArray put(int index, Object value) throws TestJSONException {
        TestJSONObject.testValidity(value);
        if (index < 0) {
            throw new TestJSONException("JSONArray[" + index + "] not found.");
        }
        if (index < this.length()) {
            this.myArrayList.set(index, value);
        } else {
            while (index != this.length()) {
                this.put(TestJSONObject.NULL);
            }
            this.put(value);
        }
        return this;
    }

    public TestJSONObject toJSONObject(TestJSONArray names) throws TestJSONException {
        if (names == null || names.length() == 0 || this.length() == 0) {
            return null;
        }
        TestJSONObject jo = new TestJSONObject();
        for (int i = 0; i < names.length(); ++i) {
            jo.put(names.getString(i), this.opt(i));
        }
        return jo;
    }

    public String toString() {
        try {
            return '[' + this.join(",") + ']';
        }
        catch (Exception e) {
            return "";
        }
    }

    public String toString(int indentFactor) throws TestJSONException {
        return this.toString(indentFactor, 0);
    }

    String toString(int indentFactor, int indent) throws TestJSONException {
        int len = this.length();
        if (len == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        if (len == 1) {
            sb.append(TestJSONObject.valueToString(this.myArrayList.get(0), indentFactor, indent));
        } else {
            int i;
            int newindent = indent + indentFactor;
            sb.append('\n');
            for (i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(",\n");
                }
                for (int j = 0; j < newindent; ++j) {
                    sb.append(' ');
                }
                sb.append(TestJSONObject.valueToString(this.myArrayList.get(i), indentFactor, newindent));
            }
            sb.append('\n');
            for (i = 0; i < indent; ++i) {
                sb.append(' ');
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public Writer write(Writer writer) throws TestJSONException {
        try {
            boolean b = false;
            int len = this.length();
            writer.write(91);
            for (int i = 0; i < len; ++i) {
                Object v;
                if (b) {
                    writer.write(44);
                }
                if ((v = this.myArrayList.get(i)) instanceof TestJSONObject) {
                    ((TestJSONObject)v).write(writer);
                } else if (v instanceof TestJSONArray) {
                    ((TestJSONArray)v).write(writer);
                } else {
                    writer.write(TestJSONObject.valueToString(v));
                }
                b = true;
            }
            writer.write(93);
            return writer;
        }
        catch (IOException e) {
            throw new TestJSONException(e);
        }
    }
}

