/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.matcher;

import com.atlassian.jira.functest.framework.backdoor.ApplicationRoleControl;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class ApplicationRoleBeanMatcher
extends TypeSafeDiagnosingMatcher<ApplicationRoleControl.ApplicationRoleBean> {
    private final String key;
    private final String name;
    private Set<String> groups = ImmutableSet.of();
    private Set<String> defaultGroups = ImmutableSet.of();
    private boolean selectedByDefault;
    private Integer numberOfSeats;
    private Integer remainingSeats;
    private Integer userCount;
    private Boolean hasUnlimitedSeats;

    public static ApplicationRoleBeanMatcher forCore() {
        return new ApplicationRoleBeanMatcher("jira-core", "Jira Core");
    }

    public ApplicationRoleBeanMatcher(String key, String name) {
        this.key = key;
        this.name = name;
    }

    protected boolean matchesSafely(ApplicationRoleControl.ApplicationRoleBean item, Description mismatchDescription) {
        boolean nameMatch = Objects.equal((Object)this.name, (Object)item.getName());
        boolean keyMatch = ApplicationRoleBeanMatcher.equalsIgnoreCase(this.key, item.getKey());
        boolean groupMatch = ApplicationRoleBeanMatcher.sameElements(this.groups, item.getGroups());
        boolean defaultGroupMatch = ApplicationRoleBeanMatcher.sameElements(this.defaultGroups, item.getDefaultGroups());
        boolean selectedByDefaultMatch = ApplicationRoleBeanMatcher.sameValue(this.selectedByDefault, item.isSelectedByDefault());
        boolean numberOfSeatsMatch = ApplicationRoleBeanMatcher.sameValue(this.numberOfSeats, item.getNumberOfSeats());
        boolean remainingSeatsMatch = ApplicationRoleBeanMatcher.sameValue(this.remainingSeats, item.getRemainingSeats());
        boolean userCountMatch = ApplicationRoleBeanMatcher.sameValue(this.userCount, item.getUserCount());
        boolean hasUnlimitedSeatsMatch = ApplicationRoleBeanMatcher.sameValue(this.hasUnlimitedSeats, item.getHasUnlimitedSeats());
        if (nameMatch && keyMatch && groupMatch && defaultGroupMatch && selectedByDefaultMatch && numberOfSeatsMatch && remainingSeatsMatch && userCountMatch && hasUnlimitedSeatsMatch) {
            return true;
        }
        mismatchDescription.appendText(String.format("[name: %s, groups: %s, key: %s, defaultGroups: %s, selectedByDefault: %b, numberOfSeats: %d, remainingSeats: %d, userCount: %d, hasUnlimitedSeats: %b]", item.getName(), item.getGroups(), item.getKey(), item.getDefaultGroups(), item.isSelectedByDefault(), item.getNumberOfSeats(), item.getRemainingSeats(), item.getUserCount(), item.getHasUnlimitedSeats()));
        mismatchDescription.appendText(System.lineSeparator());
        mismatchDescription.appendText(String.format("[nameMatch: %b, keyMatch %b, groupMatch %b, defaultGroupMatch %b, selectedByDefaultMatch %b, numberOfSeatsMatch %b, remainingSeatsMatch %b, remainingSeatsMatch %b, userCountMatch %b, hasUnlimitedSeatsMatch %b]", nameMatch, keyMatch, groupMatch, defaultGroupMatch, selectedByDefaultMatch, numberOfSeatsMatch, remainingSeatsMatch, remainingSeatsMatch, userCountMatch, hasUnlimitedSeatsMatch));
        return false;
    }

    private static <T> boolean sameValue(T left, T right) {
        return Objects.equal(left != null ? left : Preconditions.checkNotNull(right), right);
    }

    private static boolean sameElements(Collection<?> left, Collection<?> right) {
        return left.size() == right.size() && left.containsAll(right);
    }

    public void describeTo(Description description) {
        description.appendText(String.format("[name: %s, groups: %s, key: %s, defaultGroups: %s, selectedByDefault: %b, numberOfSeats: %d, remainingSeats: %d, userCount: %d, hasUnlimitedSeats: %b]", this.name, this.groups, this.key, this.defaultGroups, this.selectedByDefault, this.numberOfSeats, this.remainingSeats, this.userCount, this.hasUnlimitedSeats));
    }

    public ApplicationRoleBeanMatcher setGroups(String ... groups) {
        Preconditions.checkNotNull((Object)groups);
        this.groups = ImmutableSet.copyOf((Object[])groups);
        return this;
    }

    public ApplicationRoleBeanMatcher setDefaultGroups(String ... defaultGroups) {
        this.defaultGroups = ImmutableSet.copyOf((Object[])defaultGroups);
        return this;
    }

    public ApplicationRoleBeanMatcher setSelectedByDefault(boolean selectedByDefault) {
        this.selectedByDefault = selectedByDefault;
        return this;
    }

    public ApplicationRoleBeanMatcher setNumberOfSeats(Integer numberOfSeats) {
        this.numberOfSeats = numberOfSeats;
        return this;
    }

    public ApplicationRoleBeanMatcher setRemainingSeats(Integer remainingSeats) {
        this.remainingSeats = remainingSeats;
        return this;
    }

    public ApplicationRoleBeanMatcher setUserCount(Integer userCount) {
        this.userCount = userCount;
        return this;
    }

    private static boolean equalsIgnoreCase(String left, String right) {
        if (left == null) {
            return right == null;
        }
        return left.equalsIgnoreCase(right);
    }
}

