/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.matcher;

import java.util.Arrays;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class CsvMatcher
extends TypeSafeMatcher<String> {
    private final String expectedCsv;

    private CsvMatcher(String expectedCsv) {
        this.expectedCsv = expectedCsv;
    }

    protected boolean matchesSafely(String actualCsv) {
        return actualCsv.replace("\n", "").replace("\r", "").equals(this.expectedCsv.replace("\n", "").replace("\r", ""));
    }

    public void describeTo(Description description) {
        description.appendText("CSV files must be the same");
    }

    protected void describeMismatchSafely(String actualCsv, Description mismatchDescription) {
        String[] expectedLines = this.expectedCsv.split("\n");
        String[] actualLines = actualCsv.split("\n");
        if (actualLines.length != expectedLines.length) {
            mismatchDescription.appendText("Different line number in files: " + actualLines.length + " vs " + expectedLines.length + "\n");
        }
        Object[] expectedFieldNames = expectedLines[0].split(",");
        Object[] actualFieldNames = actualLines[0].split(",");
        if (!Arrays.equals(actualFieldNames, expectedFieldNames)) {
            mismatchDescription.appendText("Different columns names: \n" + Arrays.toString(actualFieldNames) + "\n" + Arrays.toString(expectedFieldNames) + "\n");
        }
        for (int lineIndex = 0; lineIndex < expectedLines.length; ++lineIndex) {
            String[] expectedLineFields = expectedLines[lineIndex].split(",");
            String[] actualLineFields = actualLines[lineIndex].split(",");
            if (actualLineFields.length != expectedLineFields.length) {
                mismatchDescription.appendText("Different fields size in row " + lineIndex + ": " + actualLineFields.length + " vs " + expectedLineFields.length + "\n");
            }
            for (int fieldIndex = 0; fieldIndex < expectedLineFields.length; ++fieldIndex) {
                String actualFieldValue;
                Object possibleFieldName = "unknown";
                if (fieldIndex < expectedFieldNames.length) {
                    possibleFieldName = expectedFieldNames[fieldIndex];
                }
                String string = actualFieldValue = fieldIndex >= actualLineFields.length ? "" : actualLineFields[fieldIndex];
                if (actualFieldValue.equals(expectedLineFields[fieldIndex])) continue;
                mismatchDescription.appendText("Different value in column " + lineIndex + " and field " + fieldIndex + " (could be field " + (String)possibleFieldName + " if no extra commas in data row): " + actualFieldValue + " vs " + expectedLineFields[fieldIndex] + "\n");
            }
        }
    }

    public static Matcher<String> isTheSameCSVFile(String csvContent) {
        return new CsvMatcher(csvContent);
    }
}

